/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.SharedUtils;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.flow.FlowImpl;
import com.sun.faces.flow.builder.MutableNavigationCase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import javax.faces.flow.ReturnNode;
import javax.faces.flow.SwitchCase;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private volatile Map<String, NavigationInfo> navigationMaps;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(.*)(faces-redirect=true)(.*)");
    private static final Pattern INCLUDE_VIEW_PARAMS_EQUALS_TRUE = Pattern.compile("(.*)(includeViewParams=true)(.*)");
    private static final String ROOT_NAVIGATION_MAP_ID = NavigationHandlerImpl.class.getName() + ".NAVIGATION_MAP";
    private static final String DID_TRANSITION_FLAG = "com.sun.faces.NavigationHandlerDidTransition";

    public NavigationHandlerImpl() {
        ApplicationAssociate associate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.development = associate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        return this.getNavigationCase(context, fromAction, outcome, "");
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        Util.notNull("context", context);
        Util.notNull("toFlowDocumentId", toFlowDocumentId);
        NavigationCase result = null;
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome, toFlowDocumentId);
        if (null != caseStruct) {
            result = caseStruct.navCase;
        }
        return result;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Set<NavigationCase>> result = this.getNavigationMap(context);
        return result;
    }

    public void inspectFlow(FacesContext context, Flow flow) {
        this.initializeNavigationFromFlow(context, flow);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        this.handleNavigation(context, fromAction, outcome, "");
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        Util.notNull("context", context);
        CaseStruct caseStruct = this.getViewId(context, fromAction, outcome, toFlowDocumentId);
        if (caseStruct != null) {
            ExternalContext extContext = context.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(context);
            assert (null != viewHandler);
            Flash flash = extContext.getFlash();
            boolean isUIViewActionBroadcastAndViewdsDiffer = false;
            if (UIViewAction.isProcessingBroadcast((FacesContext)context)) {
                flash.setKeepMessages(true);
                String viewIdBefore = context.getViewRoot().getViewId();
                viewIdBefore = null == viewIdBefore ? "" : viewIdBefore;
                String viewIdAfter = caseStruct.navCase.getToViewId(context);
                viewIdAfter = null == viewIdAfter ? "" : viewIdAfter;
                boolean bl = isUIViewActionBroadcastAndViewdsDiffer = !viewIdBefore.equals(viewIdAfter);
            }
            if (caseStruct.navCase.isRedirect() || isUIViewActionBroadcastAndViewdsDiffer) {
                String redirectUrl = viewHandler.getRedirectURL(context, caseStruct.viewId, SharedUtils.evaluateExpressions(context, caseStruct.navCase.getParameters()), caseStruct.navCase.isIncludeViewParams());
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Redirecting to path {0} for outcome {1}and viewId {2}", new Object[]{redirectUrl, outcome, caseStruct.viewId});
                    }
                    this.updateRenderTargets(context, caseStruct.viewId);
                    flash.setRedirect(true);
                    extContext.redirect(redirectUrl);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "jsf.redirect_failed_error", redirectUrl);
                    }
                    throw new FacesException(ioe.getMessage(), (Throwable)ioe);
                }
                context.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response complete for {0}", caseStruct.viewId);
                }
            } else {
                UIViewRoot newRoot = viewHandler.createView(context, caseStruct.viewId);
                this.updateRenderTargets(context, caseStruct.viewId);
                context.setViewRoot(newRoot);
                FlowHandler flowHandler = context.getApplication().getFlowHandler();
                if (null != flowHandler && !this.isDidTransition(context)) {
                    flowHandler.transition(context, caseStruct.currentFlow, caseStruct.newFlow, caseStruct.facesFlowCallNode, caseStruct.viewId);
                    this.setDidTransition(context, false);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Set new view in FacesContext for {0}", caseStruct.viewId);
                }
            }
            this.clearViewMapIfNecessary(context, caseStruct.viewId);
        }
    }

    private Map<String, Set<NavigationCase>> getRootNavigationMap(FacesContext context) {
        Map<String, Set<NavigationCase>> result = null;
        NavigationInfo info = null;
        if (null == this.navigationMaps) {
            this.createNavigationMaps();
            result = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
        } else {
            info = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            result = null == info.ruleSet ? Collections.emptyMap() : info.ruleSet;
        }
        return result;
    }

    private Map<String, Set<NavigationCase>> getNavigationMap(FacesContext context) {
        Map<String, Set<NavigationCase>> result = null;
        NavigationInfo info = null;
        if (null == this.navigationMaps) {
            this.createNavigationMaps();
            result = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
        } else {
            Flow currentFlow;
            FlowHandler fh = context.getApplication().getFlowHandler();
            if (null != fh && null != (currentFlow = fh.getCurrentFlow(context)) && null == (info = this.navigationMaps.get(currentFlow.getDefiningDocumentId() + currentFlow.getId()))) {
                return Collections.emptyMap();
            }
            if (null == info) {
                info = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            }
            result = null == info.ruleSet ? Collections.emptyMap() : info.ruleSet;
        }
        return result;
    }

    private void createNavigationMaps() {
        if (null == this.navigationMaps) {
            ConcurrentHashMap<String, NavigationInfo> maps = new ConcurrentHashMap<String, NavigationInfo>();
            NavigationMap result = new NavigationMap();
            NavigationInfo info = new NavigationInfo();
            info.ruleSet = result;
            maps.put(ROOT_NAVIGATION_MAP_ID, info);
            this.navigationMaps = maps;
        }
    }

    private Map<String, Set<NavigationCase>> getRootNavigationMap() {
        this.createNavigationMaps();
        return this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
    }

    private Set<String> getWildCardMatchList(FacesContext context) {
        Flow currentFlow;
        TreeSet result = Collections.emptySet();
        NavigationInfo info = null;
        FlowHandler fh = context.getApplication().getFlowHandler();
        if (null != fh && null != (currentFlow = fh.getCurrentFlow(context))) {
            info = this.navigationMaps.get(currentFlow.getDefiningDocumentId() + currentFlow.getId());
        }
        if (null == info) {
            info = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
        }
        if (null != info.ruleSet && null != info.ruleSet.wildcardMatchList) {
            result = info.ruleSet.wildcardMatchList;
        }
        return result;
    }

    private NavigationInfo getNavigationInfo(FacesContext context, String toFlowDocumentId, String flowId) {
        Flow currentFlow;
        FlowHandler fh;
        NavigationInfo result = null;
        assert (null != this.navigationMaps);
        result = this.navigationMaps.get(toFlowDocumentId + flowId);
        if (null == result && null != (fh = context.getApplication().getFlowHandler()) && null != (currentFlow = fh.getCurrentFlow(context))) {
            result = this.navigationMaps.get(currentFlow.getDefiningDocumentId() + currentFlow.getId());
        }
        return result;
    }

    private void initializeNavigationFromAssociate() {
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        if (associate != null) {
            Map<String, Set<NavigationCase>> m = associate.getNavigationCaseListMappings();
            Map<String, Set<NavigationCase>> rootMap = this.getRootNavigationMap();
            if (m != null) {
                rootMap.putAll(m);
            }
        }
    }

    private void initializeNavigationFromFlow(FacesContext context, Flow toInspect) {
        if (context instanceof InitFacesContext) {
            this.createNavigationMaps();
            this.initializeNavigationFromFlowNonThreadSafe(toInspect);
        } else {
            assert (null != this.navigationMaps);
            this.initializeNavigationFromFlowThreadSafe(toInspect);
        }
    }

    private void initializeNavigationFromFlowNonThreadSafe(Flow toInspect) {
        String fullyQualifiedFlowId = toInspect.getDefiningDocumentId() + toInspect.getId();
        if (this.navigationMaps.containsKey(fullyQualifiedFlowId)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PENDING(edburns): merge existing map");
            }
        } else {
            Map navRules = toInspect.getNavigationCases();
            Map switches = toInspect.getSwitches();
            if (!navRules.isEmpty() || !switches.isEmpty()) {
                NavigationInfo info = new NavigationInfo();
                if (!switches.isEmpty()) {
                    info.switches = new ConcurrentHashMap();
                    for (Map.Entry cur : switches.entrySet()) {
                        info.switches.put(cur.getKey(), cur.getValue());
                    }
                }
                if (!navRules.isEmpty()) {
                    info.ruleSet = new NavigationMap();
                    info.ruleSet.putAll(navRules);
                }
                this.navigationMaps.put(fullyQualifiedFlowId, info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNavigationFromFlowThreadSafe(Flow toInspect) {
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            this.initializeNavigationFromFlowNonThreadSafe(toInspect);
        }
    }

    private void clearViewMapIfNecessary(FacesContext facesContext, String newId) {
        Map viewMap;
        UIViewRoot root = facesContext.getViewRoot();
        if (root != null && !root.getViewId().equals(newId) && (viewMap = root.getViewMap(false)) != null) {
            viewMap.clear();
        }
    }

    private void updateRenderTargets(FacesContext ctx, String newId) {
        PartialViewContext pctx;
        if (!(ctx.getViewRoot() != null && ctx.getViewRoot().getViewId().equals(newId) || (pctx = ctx.getPartialViewContext()).isRenderAll())) {
            pctx.setRenderAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext ctx, String fromAction, String outcome, String toFlowDocumentId) {
        FlowHandler flowHandler;
        UIViewRoot root;
        if (this.navigationMaps == null) {
            NavigationHandlerImpl navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                this.initializeNavigationFromAssociate();
            }
        }
        String viewId = (root = ctx.getViewRoot()) != null ? root.getViewId() : null;
        CaseStruct caseStruct = null;
        Map<String, Set<NavigationCase>> navMap = this.getNavigationMap(ctx);
        if (viewId != null && (caseStruct = this.findExactMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId, navMap)) == null) {
            caseStruct = this.findWildCardMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId, navMap);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(ctx, fromAction, outcome, toFlowDocumentId, navMap);
        }
        if (null != caseStruct && caseStruct.isFlowEntryFromExplicitRule) {
            toFlowDocumentId = null != caseStruct.navCase.getToFlowDocumentId() ? caseStruct.navCase.getToFlowDocumentId() : toFlowDocumentId;
            caseStruct = this.findFacesFlowCallMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findViewNodeMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findSwitchMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != fromAction && null != outcome) {
            caseStruct = this.findMethodCallMatch(ctx, fromAction, outcome);
        }
        if (null == caseStruct && null != outcome) {
            caseStruct = this.findFacesFlowCallMatch(ctx, fromAction, outcome, toFlowDocumentId);
        }
        if (null == caseStruct && null != outcome) {
            caseStruct = this.findReturnMatch(ctx, fromAction, outcome);
        }
        if (caseStruct == null && outcome != null && viewId != null) {
            if (0 == outcome.length()) {
                outcome = null;
            } else {
                caseStruct = this.findImplicitMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId);
            }
        }
        if (caseStruct == null && outcome != null && viewId != null && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            Flow currentFlow = null;
            Object newFlow = null;
            currentFlow = flowHandler.getCurrentFlow(ctx);
            if (null != currentFlow) {
                caseStruct = this.findRootNavigationMapAbandonedFlowMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId);
            }
        }
        if (caseStruct == null && outcome != null && this.development) {
            Object[] params;
            String key;
            if (fromAction == null) {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                params = new Object[]{viewId, outcome};
            } else {
                key = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                params = new Object[]{viewId, fromAction, outcome};
            }
            FacesMessage m = MessageUtils.getExceptionMessage(key, params);
            m.setSeverity(FacesMessage.SEVERITY_WARN);
            ctx.addMessage(null, m);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext ctx, String viewId, String fromAction, String outcome, String toFlowDocumentId, Map<String, Set<NavigationCase>> navMap) {
        FlowHandler flowHandler;
        Set<NavigationCase> caseSet = navMap.get(viewId);
        if (caseSet == null) {
            return null;
        }
        CaseStruct result = this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome, toFlowDocumentId);
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow(ctx);
        }
        return result;
    }

    private CaseStruct findWildCardMatch(FacesContext ctx, String viewId, String fromAction, String outcome, String toFlowDocumentId, Map<String, Set<NavigationCase>> navMap) {
        FlowHandler flowHandler;
        CaseStruct result = null;
        for (String fromViewId : this.getWildCardMatchList(ctx)) {
            if (!viewId.startsWith(fromViewId)) continue;
            String wcFromViewId = new StringBuilder(32).append(fromViewId).append('*').toString();
            Set<NavigationCase> ccaseSet = navMap.get(wcFromViewId);
            if (ccaseSet == null) {
                return null;
            }
            result = this.determineViewFromActionOutcome(ctx, ccaseSet, fromAction, outcome, toFlowDocumentId);
            if (result == null) continue;
            break;
        }
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow(ctx);
        }
        return result;
    }

    private CaseStruct findDefaultMatch(FacesContext ctx, String fromAction, String outcome, String toFlowDocumentId, Map<String, Set<NavigationCase>> navMap) {
        FlowHandler flowHandler;
        Set<NavigationCase> caseSet = navMap.get("*");
        if (caseSet == null) {
            return null;
        }
        CaseStruct result = this.determineViewFromActionOutcome(ctx, caseSet, fromAction, outcome, toFlowDocumentId);
        if (null != result && null != (flowHandler = ctx.getApplication().getFlowHandler())) {
            result.newFlow = result.currentFlow = flowHandler.getCurrentFlow(ctx);
        }
        return result;
    }

    private CaseStruct findRootNavigationMapAbandonedFlowMatch(FacesContext ctx, String viewId, String fromAction, String outcome, String toFlowDocumentId) {
        CaseStruct caseStruct = null;
        Map<String, Set<NavigationCase>> navMap = this.getRootNavigationMap(ctx);
        if (viewId != null && (caseStruct = this.findExactMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId, navMap)) == null) {
            caseStruct = this.findWildCardMatch(ctx, viewId, fromAction, outcome, toFlowDocumentId, navMap);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(ctx, fromAction, outcome, toFlowDocumentId, navMap);
        }
        if (null != caseStruct) {
            caseStruct.newFlow = FlowImpl.ABANDONED_FLOW;
        }
        return caseStruct;
    }

    private CaseStruct findImplicitMatch(FacesContext context, String viewId, String fromAction, String outcome, String flowDefiningDocumentId) {
        int idx;
        String viewIdToTest = outcome;
        String currentViewId = viewId;
        LinkedHashMap<String, ArrayList<String>> parameters = null;
        boolean isRedirect = false;
        boolean isIncludeViewParams = false;
        CaseStruct result = null;
        int questionMark = viewIdToTest.indexOf(63);
        if (-1 != questionMark) {
            String queryString;
            int viewIdLen = viewIdToTest.length();
            if (viewIdLen <= questionMark + 1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "jsf.navigation_invalid_query_string", viewIdToTest);
                }
                if (this.development) {
                    String key = "com.sun.faces.NAVIGATION_INVALID_QUERY_STRING";
                    Object[] params = new Object[]{viewIdToTest};
                    FacesMessage m = MessageUtils.getExceptionMessage(key, params);
                    m.setSeverity(FacesMessage.SEVERITY_WARN);
                    context.addMessage(null, m);
                }
                queryString = null;
                viewIdToTest = viewIdToTest.substring(0, questionMark);
            } else {
                queryString = viewIdToTest.substring(questionMark + 1);
                viewIdToTest = viewIdToTest.substring(0, questionMark);
                Matcher m = REDIRECT_EQUALS_TRUE.matcher(queryString);
                if (m.find()) {
                    isRedirect = true;
                    queryString = queryString.replace(m.group(2), "");
                }
                if ((m = INCLUDE_VIEW_PARAMS_EQUALS_TRUE.matcher(queryString)).find()) {
                    isIncludeViewParams = true;
                    queryString = queryString.replace(m.group(2), "");
                }
            }
            if (queryString != null && queryString.length() > 0) {
                Map appMap = context.getExternalContext().getApplicationMap();
                String[] queryElements = Util.split(appMap, queryString, "&amp;|&");
                int len = queryElements.length;
                for (int i = 0; i < len; ++i) {
                    ArrayList<String> values;
                    String[] elements = Util.split(appMap, queryElements[i], "=");
                    if (elements.length != 2) continue;
                    if (parameters == null) {
                        parameters = new LinkedHashMap<String, ArrayList<String>>(len / 2, 1.0f);
                        values = new ArrayList<String>(2);
                        values.add(elements[1]);
                        parameters.put(elements[0], values);
                        continue;
                    }
                    values = (ArrayList<String>)parameters.get(elements[0]);
                    if (values == null) {
                        values = new ArrayList(2);
                        parameters.put(elements[0], values);
                    }
                    values.add(elements[1]);
                }
            }
        }
        if (viewIdToTest.lastIndexOf(46) == -1 && (idx = currentViewId.lastIndexOf(46)) != -1) {
            viewIdToTest = viewIdToTest + currentViewId.substring(idx);
        }
        if (!viewIdToTest.startsWith("/")) {
            int lastSlash = currentViewId.lastIndexOf("/");
            if (lastSlash != -1) {
                currentViewId = currentViewId.substring(0, lastSlash + 1);
                viewIdToTest = currentViewId + viewIdToTest;
            } else {
                viewIdToTest = "/" + viewIdToTest;
            }
        }
        ViewHandler viewHandler = Util.getViewHandler(context);
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        Flow currentFlow = null;
        Flow newFlow = null;
        if (null != flowHandler) {
            newFlow = currentFlow = flowHandler.getCurrentFlow(context);
            if (null != currentFlow && null != viewIdToTest && !viewIdToTest.startsWith("/" + currentFlow.getId())) {
                if ("javax.faces.flow.NullFlow".equals(flowDefiningDocumentId)) {
                    newFlow = null;
                    viewIdToTest = null;
                } else {
                    newFlow = FlowImpl.ABANDONED_FLOW;
                }
            }
        }
        if (null != viewIdToTest) {
            viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
        }
        if (null == result && null != viewIdToTest) {
            result = new CaseStruct();
            result.viewId = viewIdToTest;
            if (null == newFlow && null == currentFlow && !"javax.faces.flow.NullFlow".equals(flowDefiningDocumentId)) {
                flowDefiningDocumentId = null;
            }
            result.navCase = new NavigationCase(currentViewId, fromAction, outcome, null, viewIdToTest, flowDefiningDocumentId, parameters, isRedirect, isIncludeViewParams);
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = newFlow;
        }
        return result;
    }

    private CaseStruct findSwitchMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        SwitchNode switchNode;
        CaseStruct result = null;
        NavigationInfo info = this.getNavigationInfo(context, toFlowDocumentId, fromAction);
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null != flowHandler && null != info && null != info.switches && !info.switches.isEmpty() && null != (switchNode = (SwitchNode)info.switches.get(outcome))) {
            Flow currentFlow;
            List cases = switchNode.getCases();
            for (SwitchCase cur : cases) {
                if (!cur.getCondition(context).booleanValue()) continue;
                outcome = cur.getFromOutcome();
                Flow newFlow = flowHandler.getFlow(context, toFlowDocumentId, fromAction);
                if (null != newFlow) {
                    result = this.synthesizeCaseStruct(context, newFlow, fromAction, outcome);
                } else {
                    newFlow = flowHandler.getCurrentFlow(context);
                    if (null != newFlow) {
                        result = this.synthesizeCaseStruct(context, newFlow, fromAction, outcome);
                    }
                }
                if (null == result) continue;
                break;
            }
            if (null == result && null != (outcome = switchNode.getDefaultOutcome(context)) && null != (currentFlow = flowHandler.getCurrentFlow(context)) && null != (result = this.synthesizeCaseStruct(context, currentFlow, fromAction, outcome))) {
                result.currentFlow = currentFlow;
                result.newFlow = currentFlow;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CaseStruct synthesizeCaseStruct(FacesContext context, Flow flow, String fromAction, String outcome) {
        CaseStruct result = null;
        FlowNode node = flow.getNode(outcome);
        if (null != node) {
            if (node instanceof ViewNode) {
                result = new CaseStruct();
                result.viewId = ((ViewNode)node).getVdlDocumentId();
                result.navCase = new MutableNavigationCase(fromAction, fromAction, outcome, null, result.viewId, flow.getDefiningDocumentId(), null, false, false);
                return result;
            } else {
                if (!(node instanceof ReturnNode)) return result;
                String fromOutcome = ((ReturnNode)node).getFromOutcome(context);
                FlowHandler flowHandler = context.getApplication().getFlowHandler();
                try {
                    flowHandler.pushReturnMode(context);
                    result = this.getViewId(context, fromAction, fromOutcome, "javax.faces.flow.NullFlow");
                    if (null == result) {
                        String toViewId;
                        Flow precedingFlow = flowHandler.getCurrentFlow(context);
                        if (null == precedingFlow || null == (toViewId = flowHandler.getLastDisplayedViewId(context))) return result;
                        result = new CaseStruct();
                        result.viewId = toViewId;
                        result.navCase = new MutableNavigationCase(context.getViewRoot().getViewId(), fromAction, outcome, null, toViewId, "javax.faces.flow.NullFlow", null, false, false);
                        return result;
                    }
                    result.newFlow = FlowImpl.SYNTHESIZED_RETURN_CASE_FLOW;
                    return result;
                }
                finally {
                    flowHandler.popReturnMode(context);
                }
            }
        } else {
            String currentViewId = outcome;
            int idx = currentViewId.lastIndexOf(46);
            String currentExtension = idx != -1 ? currentViewId.substring(idx) : ".xhtml";
            String viewIdToTest = "/" + flow.getId() + "/" + outcome + currentExtension;
            ViewHandler viewHandler = Util.getViewHandler(context);
            viewIdToTest = viewHandler.deriveViewId(context, viewIdToTest);
            if (null == viewIdToTest) return result;
            result = new CaseStruct();
            result.viewId = viewIdToTest;
            result.navCase = new MutableNavigationCase(fromAction, fromAction, outcome, null, result.viewId, null, false, false);
        }
        return result;
    }

    private CaseStruct findMethodCallMatch(FacesContext context, String fromAction, String outcome) {
        MethodCallNode methodCallNode;
        MethodExpression me;
        FlowNode node;
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        if (null != currentFlow && (node = currentFlow.getNode(outcome)) instanceof MethodCallNode && null != (me = (methodCallNode = (MethodCallNode)node).getMethodExpression())) {
            ValueExpression ve;
            Object invokeResult;
            List paramList = methodCallNode.getParameters();
            Object[] params = null;
            if (null != paramList) {
                params = new Object[paramList.size()];
                int i = 0;
                ELContext elContext = context.getELContext();
                for (Parameter cur : paramList) {
                    params[i++] = cur.getValue().getValue(elContext);
                }
            }
            if (null == (invokeResult = me.invoke(context.getELContext(), params)) && null != (ve = methodCallNode.getOutcome())) {
                invokeResult = ve.getValue(context.getELContext());
            }
            if (null != (result = this.synthesizeCaseStruct(context, currentFlow, fromAction, outcome = invokeResult.toString()))) {
                result.currentFlow = currentFlow;
                result.newFlow = result.newFlow == FlowImpl.SYNTHESIZED_RETURN_CASE_FLOW ? null : currentFlow;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct findFacesFlowCallMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        Flow newFlow = null;
        FlowCallNode facesFlowCallNode = null;
        if (null != currentFlow) {
            FlowNode node = currentFlow.getNode(outcome);
            if (node instanceof FlowCallNode) {
                String startNodeId;
                facesFlowCallNode = (FlowCallNode)node;
                String flowId = facesFlowCallNode.getCalledFlowId(context);
                String flowDocumentId = facesFlowCallNode.getCalledFlowDocumentId(context);
                if (null != flowId && null != (newFlow = flowHandler.getFlow(context, flowDocumentId, flowId)) && null == (result = this.synthesizeCaseStruct(context, newFlow, fromAction, startNodeId = newFlow.getStartNodeId()))) {
                    assert (null != currentFlow);
                    try {
                        this.setDidTransition(context, true);
                        flowHandler.transition(context, currentFlow, newFlow, null, startNodeId);
                        result = this.getViewId(context, fromAction, startNodeId, toFlowDocumentId);
                    }
                    finally {
                        if (null == result) {
                            flowHandler.transition(context, newFlow, currentFlow, null, outcome);
                            this.setDidTransition(context, false);
                        }
                    }
                }
            }
        } else {
            newFlow = flowHandler.getFlow(context, toFlowDocumentId, outcome);
            if (null != newFlow) {
                String startNodeId = newFlow.getStartNodeId();
                result = this.synthesizeCaseStruct(context, newFlow, fromAction, startNodeId);
                if (null == result) {
                    assert (null == currentFlow);
                    try {
                        this.setDidTransition(context, true);
                        flowHandler.transition(context, null, newFlow, null, startNodeId);
                        result = this.getViewId(context, fromAction, startNodeId, toFlowDocumentId);
                    }
                    finally {
                        if (null == result) {
                            flowHandler.transition(context, newFlow, null, null, outcome);
                            this.setDidTransition(context, false);
                        }
                    }
                } else if (!outcome.equals(startNodeId) && null != result.navCase) {
                    ((MutableNavigationCase)result.navCase).setFromOutcome(outcome);
                }
            }
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = newFlow;
            result.facesFlowCallNode = facesFlowCallNode;
        }
        return result;
    }

    private boolean isDidTransition(FacesContext context) {
        boolean result = context.getAttributes().containsKey(DID_TRANSITION_FLAG);
        return result;
    }

    private void setDidTransition(FacesContext context, boolean value) {
        Map contextMap = context.getAttributes();
        if (value) {
            contextMap.put(DID_TRANSITION_FLAG, Boolean.TRUE);
        } else {
            contextMap.remove(DID_TRANSITION_FLAG);
        }
    }

    private CaseStruct findViewNodeMatch(FacesContext context, String fromAction, String outcome, String toFlowDocumentId) {
        FlowNode node;
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        if (null != currentFlow && null != (node = currentFlow.getNode(outcome)) && node instanceof ViewNode) {
            result = this.synthesizeCaseStruct(context, currentFlow, fromAction, outcome);
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = currentFlow;
            result.facesFlowCallNode = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct findReturnMatch(FacesContext context, String fromAction, String outcome) {
        ReturnNode returnNode;
        CaseStruct result = null;
        FlowHandler flowHandler = context.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow currentFlow = flowHandler.getCurrentFlow(context);
        if (null != currentFlow && null != (returnNode = (ReturnNode)currentFlow.getReturns().get(outcome))) {
            String fromOutcome = returnNode.getFromOutcome(context);
            try {
                String toViewId;
                Flow precedingFlow;
                flowHandler.pushReturnMode(context);
                result = this.getViewId(context, fromAction, fromOutcome, "javax.faces.flow.NullFlow");
                if (null == result && null != (precedingFlow = flowHandler.getCurrentFlow(context)) && null != (toViewId = flowHandler.getLastDisplayedViewId(context))) {
                    result = new CaseStruct();
                    result.viewId = toViewId;
                    result.navCase = new NavigationCase(context.getViewRoot().getViewId(), fromAction, outcome, null, toViewId, "javax.faces.flow.NullFlow", null, false, false);
                }
            }
            finally {
                flowHandler.popReturnMode(context);
            }
        }
        if (null != result) {
            result.currentFlow = currentFlow;
            result.newFlow = null;
        }
        return result;
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext ctx, Set<NavigationCase> caseSet, String fromAction, String outcome, String toFlowDocumentId) {
        CaseStruct result = new CaseStruct();
        boolean match = false;
        for (NavigationCase cnc : caseSet) {
            String cncFromAction = cnc.getFromAction();
            String cncFromOutcome = cnc.getFromOutcome();
            boolean cncHasCondition = cnc.hasCondition();
            String cncToViewId = cnc.getToViewId(ctx);
            if (cncFromAction != null && cncFromOutcome != null) {
                if (cncFromAction.equals(fromAction) && cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome != null) {
                if (cncFromOutcome.equals(outcome)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction != null && cncFromOutcome == null) {
                if (cncFromAction.equals(fromAction) && (outcome != null || cncHasCondition)) {
                    result.viewId = cncToViewId;
                    result.navCase = cnc;
                    match = true;
                }
            } else if (cncFromAction == null && cncFromOutcome == null && (outcome != null || cncHasCondition)) {
                result.viewId = cncToViewId;
                result.navCase = cnc;
                match = true;
            }
            if (!match) continue;
            if (cncHasCondition && Boolean.FALSE.equals(cnc.getCondition(ctx))) {
                match = false;
                continue;
            }
            String string = toFlowDocumentId = null != cnc.getToFlowDocumentId() ? cnc.getToFlowDocumentId() : toFlowDocumentId;
            if (null != toFlowDocumentId) {
                FlowHandler fh = ctx.getApplication().getFlowHandler();
                if (null != outcome) {
                    result.isFlowEntryFromExplicitRule = null != fh.getFlow(ctx, toFlowDocumentId, outcome);
                }
            }
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NavigationMap
    extends AbstractMap<String, Set<NavigationCase>> {
        private HashMap<String, Set<NavigationCase>> navigationMap = new HashMap();
        private TreeSet<String> wildcardMatchList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String fromViewId1, String fromViewId2) {
                return -fromViewId1.compareTo(fromViewId2);
            }
        });

        private NavigationMap() {
        }

        @Override
        public int size() {
            return this.navigationMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.navigationMap.isEmpty();
        }

        @Override
        public Set<NavigationCase> put(String key, Set<NavigationCase> value) {
            if (key == null) {
                throw new IllegalArgumentException(key);
            }
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.updateWildcards(key);
            Set<NavigationCase> existing = this.navigationMap.get(key);
            if (existing == null) {
                this.navigationMap.put(key, value);
                return null;
            }
            existing.addAll(value);
            return existing;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Set<NavigationCase>> m) {
            if (m == null) {
                return;
            }
            for (Map.Entry<? extends String, ? extends Set<NavigationCase>> entry : m.entrySet()) {
                String key = entry.getKey();
                this.updateWildcards(key);
                Set<NavigationCase> existing = this.navigationMap.get(key);
                if (existing == null) {
                    this.navigationMap.put(key, entry.getValue());
                    continue;
                }
                existing.addAll((Collection<NavigationCase>)entry.getValue());
            }
        }

        @Override
        public Set<String> keySet() {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Collection<Set<NavigationCase>> values() {
            return new AbstractCollection<Set<NavigationCase>>(){

                @Override
                public Iterator<Set<NavigationCase>> iterator() {
                    return new Iterator<Set<NavigationCase>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<NavigationCase> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
            return new AbstractSet<Map.Entry<String, Set<NavigationCase>>>(){

                @Override
                public Iterator<Map.Entry<String, Set<NavigationCase>>> iterator() {
                    return new Iterator<Map.Entry<String, Set<NavigationCase>>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.navigationMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Set<NavigationCase>> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        private void updateWildcards(String fromViewId) {
            if (!this.navigationMap.containsKey(fromViewId) && fromViewId.endsWith("*")) {
                this.wildcardMatchList.add(fromViewId.substring(0, fromViewId.lastIndexOf(42)));
            }
        }
    }

    private static final class NavigationInfo {
        private NavigationMap ruleSet;
        private Map<String, SwitchNode> switches;

        private NavigationInfo() {
        }
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;
        Flow currentFlow;
        Flow newFlow;
        FlowCallNode facesFlowCallNode;
        boolean isFlowEntryFromExplicitRule = false;

        private CaseStruct() {
        }
    }
}

