/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import org.jboss.dmr.ModelNode;

public class PathEntry {
    private final String name;
    private volatile String path;
    private volatile String relativeTo;
    private final boolean readOnly;
    private volatile PathResolver resolver;

    PathEntry(String name, String path, String relativeTo, boolean readOnly, PathResolver resolver) {
        this.name = name;
        this.path = path;
        this.relativeTo = relativeTo;
        this.readOnly = readOnly;
        this.resolver = resolver;
    }

    public PathEntry(PathEntry pathEntry) {
        this.name = pathEntry.name;
        this.path = pathEntry.path;
        this.relativeTo = pathEntry.relativeTo;
        this.readOnly = pathEntry.readOnly;
        this.resolver = pathEntry.resolver;
    }

    public String getName() {
        return this.name;
    }

    public String resolvePath() {
        return this.resolver.resolvePath(this.name, this.path, this.relativeTo, this.resolver);
    }

    String getPath() {
        return this.path;
    }

    String getRelativeTo() {
        return this.relativeTo;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    void setPath(String path) {
        this.path = path;
    }

    void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    boolean isResolved() {
        return this.resolver.isResolved(this.relativeTo);
    }

    ModelNode toModel() {
        ModelNode model = new ModelNode();
        model.get("name").set(this.name);
        model.get("path").set(this.path);
        if (this.relativeTo != null) {
            model.get("relative-to").set(this.relativeTo);
        } else {
            model.get("relative-to");
        }
        if (this.readOnly) {
            model.get("read-only").set(this.readOnly);
        }
        return model;
    }

    static interface PathResolver {
        public String resolvePath(String var1, String var2, String var3, PathResolver var4);

        public boolean isResolved(String var1);
    }
}

