/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.RepeatableParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;

public class AppendingArrayRepeatableHandler
implements RepeatableParticleHandler {
    private final PropertyInfo propertyInfo;
    private final ArrayInfo arrayInfo;
    private final AbstractPropertyHandler targetHandler;

    public AppendingArrayRepeatableHandler(AbstractPropertyHandler propertyHandler) {
        this.propertyInfo = propertyHandler.getPropertyInfo();
        this.arrayInfo = (ArrayInfo)propertyHandler.getPropertyType();
        this.targetHandler = propertyHandler;
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName name) {
    }

    public void addTermValue(Object particleValue, Object termValue, QName elementName, ParticleBinding particle, ParticleBinding parentParticle, ParticleHandler handler) {
        ((List)particleValue).add(termValue);
    }

    public void endRepeatableParticle(Object parent, Object o, QName name, ParticleBinding particle, ParticleBinding parentParticle) {
        Object[] arr;
        ValueAdapter valueAdapter = particle.getTerm().getValueAdapter();
        if (valueAdapter != null) {
            o = valueAdapter.cast(o, null);
        }
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        Object currentArray = null;
        try {
            if (this.propertyInfo.getGetter() != null) {
                currentArray = beanAdapter.get(this.propertyInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + name + " error getting array property " + this.propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
        }
        List elements = (List)o;
        if (currentArray == null) {
            try {
                arr = (Object[])this.arrayInfo.newArrayInstance(elements.size());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating array of type " + this.arrayInfo.getName() + " from " + elements, t);
            }
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = elements.get(i);
            }
        } else {
            int currentLength = Array.getLength(currentArray);
            try {
                arr = (Object[])this.arrayInfo.newArrayInstance(currentLength + elements.size());
            }
            catch (Throwable e) {
                throw new RuntimeException("Error creating array of type " + this.arrayInfo.getName() + " from " + elements, e);
            }
            System.arraycopy(currentArray, 0, arr, 0, currentLength);
            for (int i = 0; i < elements.size(); ++i) {
                arr[currentLength + i] = elements.get(i);
            }
        }
        this.targetHandler.doHandle(parent, arr, name);
    }

    public Object startRepeatableParticle(Object parent, QName startName, ParticleBinding particle) {
        return new ArrayList();
    }
}

