/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.hotrod.HotRodServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ExtensionManagerService
implements Service<ExtensionManagerService> {
    private final List<HotRodServer> servers = new ArrayList<HotRodServer>();
    private final Map<String, CacheEventFilterFactory> filterFactories = new HashMap<String, CacheEventFilterFactory>();
    private final Map<String, CacheEventConverterFactory> converterFactories = new HashMap<String, CacheEventConverterFactory>();
    private final Map<String, CacheEventFilterConverterFactory> filterConverterFactories = new HashMap<String, CacheEventFilterConverterFactory>();

    public void start(StartContext context) throws StartException {
        EndpointLogger.ROOT_LOGGER.debugf("Started server extension manager", new Object[0]);
    }

    public void stop(StopContext context) {
        EndpointLogger.ROOT_LOGGER.debugf("Stopped server extension manager", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHotRodServer(HotRodServer server) {
        Map<String, CacheEventConverterFactory> map = this.servers;
        synchronized (map) {
            this.servers.add(server);
        }
        map = this.filterFactories;
        synchronized (map) {
            for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterFactories.entrySet()) {
                server.addCacheEventFilterFactory(entry.getKey(), entry.getValue());
            }
        }
        map = this.converterFactories;
        synchronized (map) {
            for (Map.Entry<String, CacheEventFilterFactory> entry : this.converterFactories.entrySet()) {
                server.addCacheEventConverterFactory(entry.getKey(), (CacheEventConverterFactory)entry.getValue());
            }
        }
        map = this.filterConverterFactories;
        synchronized (map) {
            for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterConverterFactories.entrySet()) {
                server.addCacheEventFilterConverterFactory(entry.getKey(), (CacheEventFilterConverterFactory)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHotRodServer(HotRodServer server) {
        Map<String, CacheEventConverterFactory> map = this.servers;
        synchronized (map) {
            this.servers.remove(server);
        }
        map = this.filterFactories;
        synchronized (map) {
            for (String name : this.filterFactories.keySet()) {
                server.removeCacheEventFilterFactory(name);
            }
        }
        map = this.converterFactories;
        synchronized (map) {
            for (String name : this.converterFactories.keySet()) {
                server.removeCacheEventConverterFactory(name);
            }
        }
        map = this.filterConverterFactories;
        synchronized (map) {
            for (String name : this.filterConverterFactories.keySet()) {
                server.removeCacheEventFilterConverterFactory(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterFactory(String name, CacheEventFilterFactory factory) {
        Object object = this.filterFactories;
        synchronized (object) {
            this.filterFactories.put(name, factory);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.addCacheEventFilterFactory(name, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterFactory(String name) {
        Object object = this.filterFactories;
        synchronized (object) {
            this.filterFactories.remove(name);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.removeCacheEventFilterFactory(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConverterFactory(String name, CacheEventConverterFactory factory) {
        Object object = this.converterFactories;
        synchronized (object) {
            this.converterFactories.put(name, factory);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.addCacheEventConverterFactory(name, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConverterFactory(String name) {
        Object object = this.converterFactories;
        synchronized (object) {
            this.converterFactories.remove(name);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.removeCacheEventConverterFactory(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterConverterFactory(String name, CacheEventFilterConverterFactory factory) {
        Object object = this.filterConverterFactories;
        synchronized (object) {
            this.filterConverterFactories.put(name, factory);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.addCacheEventFilterConverterFactory(name, factory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterConverterFactory(String name) {
        Object object = this.filterConverterFactories;
        synchronized (object) {
            this.filterConverterFactories.remove(name);
        }
        object = this.servers;
        synchronized (object) {
            for (HotRodServer server : this.servers) {
                server.removeCacheEventFilterConverterFactory(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMarshaller(Marshaller marshaller) {
        List<HotRodServer> list = this.servers;
        synchronized (list) {
            for (HotRodServer server : this.servers) {
                server.setMarshaller(marshaller);
            }
        }
    }

    public ExtensionManagerService getValue() {
        return this;
    }
}

