/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;

public abstract class AbstractContext
implements AlterableContext {
    private final boolean multithreaded;
    private final ServiceRegistry serviceRegistry;

    public AbstractContext(String contextId, boolean multithreaded) {
        this.multithreaded = multithreaded;
        this.serviceRegistry = Container.instance(contextId).services();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="False positive from FindBugs")
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        this.checkContextInitialized();
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            return null;
        }
        if (contextual == null) {
            throw ContextLogger.LOG.contextualIsNull();
        }
        BeanIdentifier id = this.getId(contextual);
        Object beanInstance = beanStore.get(id);
        if (beanInstance != null) {
            return (T)beanInstance.getInstance();
        }
        if (creationalContext != null) {
            LockedBean lock = null;
            try {
                Object instance;
                if (this.multithreaded) {
                    lock = beanStore.lock(id);
                    beanInstance = beanStore.get(id);
                    if (beanInstance != null) {
                        Object object = beanInstance.getInstance();
                        return (T)object;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, Object>(contextual, instance, creationalContext, (ContextualStore)this.serviceRegistry.get(ContextualStore.class));
                    this.getBeanStore().put(id, beanInstance);
                }
                Object object = instance;
                return (T)object;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public void destroy(Contextual<?> contextual) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        this.checkContextInitialized();
        if (contextual == null) {
            throw ContextLogger.LOG.contextualIsNull();
        }
        if (this.getBeanStore() == null) {
            throw ContextLogger.LOG.noBeanStoreAvailable(this);
        }
        BeanIdentifier id = this.getId(contextual);
        ContextualInstance beanInstance = this.getBeanStore().remove(id);
        if (beanInstance != null) {
            RequestScopedBeanCache.invalidate();
            this.destroyContextualInstance(beanInstance);
        }
    }

    private <T> ContextualInstance<T> getContextualInstance(BeanIdentifier id) {
        if (this.getBeanStore() == null) {
            throw ContextLogger.LOG.noBeanStoreAvailable(this);
        }
        return this.getBeanStore().get(id);
    }

    private <T> void destroyContextualInstance(ContextualInstance<T> instance) {
        instance.getContextual().destroy(instance.getInstance(), instance.getCreationalContext());
        ContextLogger.LOG.contextualInstanceRemoved(instance, this);
    }

    protected void destroy() {
        ContextLogger.LOG.contextCleared(this);
        if (this.getBeanStore() == null) {
            throw ContextLogger.LOG.noBeanStoreAvailable(this);
        }
        for (BeanIdentifier id : this.getBeanStore()) {
            this.destroyContextualInstance(this.getContextualInstance(id));
        }
        this.getBeanStore().clear();
    }

    protected abstract BeanStore getBeanStore();

    public void cleanup() {
        if (this.getBeanStore() != null) {
            try {
                this.getBeanStore().clear();
            }
            catch (Exception e) {
                ContextLogger.LOG.unableToClearBeanStore(this.getBeanStore());
                ContextLogger.LOG.catchingDebug(e);
            }
        }
    }

    protected static <T> Contextual<T> getContextual(String contextId, String id) {
        return ((ContextualStore)Container.instance(contextId).services().get(ContextualStore.class)).getContextual(id);
    }

    protected BeanIdentifier getId(Contextual<?> contextual) {
        return ((ContextualStore)this.serviceRegistry.get(ContextualStore.class)).putIfAbsent(contextual);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void checkContextInitialized() {
    }
}

