/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.AbstractCollection;
import org.jboss.util.collection.EmptyCollectionException;
import org.jboss.util.collection.FullCollectionException;
import org.jboss.util.collection.Queue;

public abstract class AbstractQueue<E>
extends AbstractCollection<E>
implements Queue<E> {
    public static int DEFAULT_MAXIMUM_SIZE = -1;
    protected int maximumSize = DEFAULT_MAXIMUM_SIZE;

    protected AbstractQueue() {
    }

    protected AbstractQueue(int maxSize) {
        this.setMaximumSize(maxSize);
    }

    @Override
    public int getMaximumSize() {
        return this.maximumSize;
    }

    @Override
    public void setMaximumSize(int size) {
        if (size < 0 && size != -1) {
            throw new IllegalArgumentException("illegal size: " + size);
        }
        this.maximumSize = size;
    }

    @Override
    public boolean isFull() {
        return this.maximumSize != -1 && this.size() >= this.maximumSize;
    }

    @Override
    public boolean isEmpty() {
        return this.size() <= 0;
    }

    @Override
    public boolean add(E obj) throws FullCollectionException {
        if (this.isFull()) {
            throw new FullCollectionException();
        }
        return this.addLast(obj);
    }

    @Override
    public E remove() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.removeFirst();
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.remove();
        }
    }

    protected abstract boolean addLast(E var1);

    protected abstract E removeFirst();
}

