/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.security.cert.X509Certificate;
import javax.security.auth.callback.CallbackHandler;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecEncrypt;
import org.w3c.dom.Document;

public class EncryptionAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        WSSecEncrypt wsEncrypt = new WSSecEncrypt(reqData.getWssConfig());
        if (reqData.getEncKeyId() != 0) {
            wsEncrypt.setKeyIdentifierType(reqData.getEncKeyId());
        }
        if (reqData.getEncKeyId() == 5) {
            String encKeyName = handler.getString("embeddedKeyName", reqData.getMsgContext());
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            CallbackHandler callbackHandler = handler.getCallbackHandler("embeddedKeyCallbackClass", "embeddedKeyCallbackRef", reqData);
            WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getEncUser(), actionToDo, callbackHandler, reqData);
            byte[] embeddedKey = passwordCallback.getKey();
            wsEncrypt.setKey(embeddedKey);
            wsEncrypt.setDocument(doc);
        }
        if (reqData.getEncSymmAlgo() != null) {
            wsEncrypt.setSymmetricEncAlgorithm(reqData.getEncSymmAlgo());
        }
        if (reqData.getEncKeyTransport() != null) {
            wsEncrypt.setKeyEnc(reqData.getEncKeyTransport());
        }
        if (reqData.getEncDigestAlgorithm() != null) {
            wsEncrypt.setDigestAlgorithm(reqData.getEncDigestAlgorithm());
        }
        wsEncrypt.setUserInfo(reqData.getEncUser());
        wsEncrypt.setUseThisCert(reqData.getEncCert());
        Crypto crypto = reqData.getEncCrypto();
        boolean enableRevocation = Boolean.valueOf(handler.getStringOption("enableRevocation"));
        if (enableRevocation && crypto != null) {
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias(reqData.getEncUser());
            X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
            if (certs != null && certs.length > 0) {
                crypto.verifyTrust(certs, enableRevocation);
            }
        }
        if (reqData.getEncryptParts().size() > 0) {
            wsEncrypt.setParts(reqData.getEncryptParts());
        }
        if (!reqData.getEncryptSymmetricEncryptionKey()) {
            CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
            WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getEncUser(), actionToDo, callbackHandler, reqData);
            wsEncrypt.setEphemeralKey(passwordCallback.getKey());
            wsEncrypt.setEncryptSymmKey(reqData.getEncryptSymmetricEncryptionKey());
        }
        try {
            wsEncrypt.build(doc, reqData.getEncCrypto(), reqData.getSecHeader());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("Error during encryption: ", e);
        }
    }
}

