/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.ir.Contained;
import org.jacorb.ir.ContainerType;
import org.jacorb.ir.IDLType;
import org.jacorb.ir.IRFilenameFilter;
import org.jacorb.ir.IRObject;
import org.jacorb.ir.TypedefDef;
import org.omg.CORBA.AliasDef;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ConstantDef;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.Container;
import org.omg.CORBA.ContainerPackage.Description;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.EnumDef;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.Initializer;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ModuleDef;
import org.omg.CORBA.NativeDef;
import org.omg.CORBA.Repository;
import org.omg.CORBA.StructDefHelper;
import org.omg.CORBA.StructDefOperations;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeDescription;
import org.omg.CORBA.TypeDescriptionHelper;
import org.omg.CORBA.UnionDef;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueBoxDef;
import org.omg.CORBA.ValueDef;
import org.omg.PortableServer.POA;
import org.slf4j.Logger;

public class StructDef
extends TypedefDef
implements StructDefOperations,
ContainerType {
    private TypeCode type;
    private Class myClass;
    private Class helperClass;
    private StructMember[] members;
    private Hashtable containedLocals = new Hashtable();
    private Hashtable contained = new Hashtable();
    private File my_dir;
    private String path;
    private boolean defined = false;
    private Logger logger;
    private ClassLoader loader;
    private POA poa;

    public StructDef(Class c, String path, Container _defined_in, Repository ir, Logger logger, ClassLoader loader, POA poa) {
        this.logger = logger;
        this.loader = loader;
        this.poa = poa;
        this.def_kind = DefinitionKind.dk_Struct;
        this.containing_repository = ir;
        this.defined_in = _defined_in;
        this.path = path;
        if (this.defined_in == null) {
            throw new INTF_REPOS("defined_in = null");
        }
        if (this.containing_repository == null) {
            throw new INTF_REPOS("containing_repository = null");
        }
        try {
            String classId = c.getName();
            this.myClass = c;
            this.version("1.0");
            this.full_name = classId;
            if (classId.indexOf(46) > 0) {
                this.name(classId.substring(classId.lastIndexOf(46) + 1));
                this.absolute_name = ContainedHelper.narrow(this.defined_in).absolute_name() + "::" + this.name;
            } else {
                this.name(classId);
                this.absolute_name = "::" + this.name;
            }
            this.helperClass = this.loader.loadClass(classId + "Helper");
            this.id((String)this.helperClass.getDeclaredMethod("id", null).invoke(null, (Object[])null));
            this.type = (TypeCode)this.helperClass.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            this.members = new StructMember[this.type.member_count()];
            for (int i = 0; i < this.members.length; ++i) {
                TypeCode type_code = this.type.member_type(i);
                String member_name = this.type.member_name(i);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("StructDef " + this.absolute_name + " member " + member_name);
                }
                this.members[i] = new StructMember(member_name, type_code, null);
            }
            File f = new File(path + fileSeparator + classId.replace('.', fileSeparator) + "Package");
            if (f.exists() && f.isDirectory()) {
                this.my_dir = f;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("StructDef: " + this.absolute_name);
            }
        }
        catch (Exception e) {
            logger.error("Caught Exception", (Throwable)e);
            throw new INTF_REPOS(2600, CompletionStatus.COMPLETED_NO);
        }
    }

    public void loadContents() {
        if (this.getReference() == null) {
            throw new INTF_REPOS("getReference returns null");
        }
        org.omg.CORBA.StructDef myReference = StructDefHelper.narrow(this.getReference());
        if (myReference == null) {
            throw new INTF_REPOS("narrow failed for " + this.getReference());
        }
        String[] classes = null;
        if (this.my_dir != null && (classes = this.my_dir.list(new IRFilenameFilter(".class"))) != null) {
            for (int j = 0; j < classes.length; ++j) {
                try {
                    Class<?> cl;
                    Contained containedObject;
                    ClassLoader loader;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Struct " + this.name + " tries " + this.full_name + "Package." + classes[j].substring(0, classes[j].indexOf(".class")));
                    }
                    if ((loader = this.getClass().getClassLoader()) == null) {
                        loader = this.loader;
                    }
                    if ((containedObject = Contained.createContained(cl = loader.loadClass(this.full_name + "Package." + classes[j].substring(0, classes[j].indexOf(".class"))), this.path, myReference, this.containing_repository, this.logger, this.loader, this.poa)) == null) continue;
                    org.omg.CORBA.Contained containedRef = Contained.createContainedReference(containedObject, this.logger, this.poa);
                    if (containedObject instanceof ContainerType) {
                        ((ContainerType)((Object)containedObject)).loadContents();
                    }
                    containedRef.move(myReference, containedRef.name(), containedRef.version());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Struct " + this.full_name + " loads " + containedRef.name());
                    }
                    this.contained.put(containedRef.name(), containedRef);
                    this.containedLocals.put(containedRef.name(), containedObject);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("Caught Exception", (Throwable)e);
                }
            }
        }
    }

    public void define() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Struct " + this.name + " defining...");
        }
        Enumeration e = this.containedLocals.elements();
        while (e.hasMoreElements()) {
            ((IRObject)e.nextElement()).define();
        }
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].type_def = IDLType.create(this.members[i].type, this.containing_repository, this.logger, this.poa);
            if (this.members[i].type_def != null) continue;
            throw new INTF_REPOS("No type_def for member " + this.members[i].name + " in struct " + this.full_name);
        }
        this.defined = true;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Struct " + this.name + " defined");
        }
    }

    TypeDescription describe_struct() {
        if (!this.defined) {
            throw new INTF_REPOS("Struct " + this.full_name + " not defined! ");
        }
        return new TypeDescription(this.name(), this.id(), ContainedHelper.narrow(this.defined_in).id(), this.version(), this.type());
    }

    public TypeCode type() {
        if (this.type == null) {
            throw new INTF_REPOS("Struct TypeCode is null");
        }
        return this.type;
    }

    public org.omg.CORBA.Contained lookup(String scopedname) {
        String rest_of_name;
        String top_level_name;
        String name;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Struct " + this.name + " lookup " + scopedname);
        }
        if ((name = scopedname.startsWith("::") ? scopedname.substring(2) : scopedname).indexOf("::") > 0) {
            top_level_name = name.substring(0, name.indexOf("::"));
            rest_of_name = name.substring(name.indexOf("::") + 2);
        } else {
            top_level_name = name;
            rest_of_name = null;
        }
        try {
            org.omg.CORBA.Contained top = (org.omg.CORBA.Contained)this.contained.get(top_level_name);
            if (top == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Interface " + this.name + " top " + top_level_name + " not found ");
                }
                return null;
            }
            if (rest_of_name == null) {
                return top;
            }
            if (top instanceof Container) {
                return ((Container)((Object)top)).lookup(rest_of_name);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Interface " + this.name + " " + scopedname + " not found");
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("Caught Exception", (Throwable)e);
            return null;
        }
    }

    public StructMember[] members() {
        if (!this.defined) {
            throw new INTF_REPOS("Struct " + this.full_name + " not defined! ");
        }
        return this.members;
    }

    public void members(StructMember[] a) {
    }

    public ModuleDef create_module(String id, String name, String version) {
        return null;
    }

    public ConstantDef create_constant(String id, String name, String version, org.omg.CORBA.IDLType type, Any value) {
        return null;
    }

    public org.omg.CORBA.StructDef create_struct(String id, String name, String version, StructMember[] members) {
        return null;
    }

    public UnionDef create_union(String id, String name, String version, org.omg.CORBA.IDLType discriminator_type, UnionMember[] members) {
        return null;
    }

    public EnumDef create_enum(String id, String name, String version, String[] members) {
        return null;
    }

    public AliasDef create_alias(String id, String name, String version, org.omg.CORBA.IDLType original_type) {
        return null;
    }

    public ExceptionDef create_exception(String id, String name, String version, StructMember[] member) {
        return null;
    }

    public InterfaceDef create_interface(String id, String name, String version, InterfaceDef[] base_interfaces, boolean is_abstract) {
        return null;
    }

    public ValueBoxDef create_value_box(String id, String name, String version, org.omg.CORBA.IDLType type) {
        return null;
    }

    public ValueDef create_value(String id, String name, String version, boolean is_custom, boolean is_abstract, ValueDef base_value, boolean is_truncatable, ValueDef[] abstract_base_values, InterfaceDef[] supported_interfaces, Initializer[] initializers) {
        return null;
    }

    public NativeDef create_native(String id, String name, String version) {
        return null;
    }

    public void destroy() {
        throw new INTF_REPOS(2600, CompletionStatus.COMPLETED_NO);
    }

    public org.omg.CORBA.Contained[] lookup_name(String search_name, int levels_to_search, DefinitionKind limit_type, boolean exclude_inherited) {
        int i;
        if (levels_to_search == 0) {
            return null;
        }
        org.omg.CORBA.Contained[] c = this.contents(limit_type, exclude_inherited);
        Hashtable<org.omg.CORBA.Contained, String> found = new Hashtable<org.omg.CORBA.Contained, String>();
        for (i = 0; i < c.length; ++i) {
            if (!c[i].name().equals(search_name)) continue;
            found.put(c[i], "");
        }
        if (levels_to_search > 1 || levels_to_search == -1) {
            for (i = 0; i < c.length; ++i) {
                org.omg.CORBA.Contained[] tmp_seq;
                if (!(c[i] instanceof Container) || (tmp_seq = ((Container)((Object)c[i])).lookup_name(search_name, levels_to_search - 1, limit_type, exclude_inherited)) == null) continue;
                for (int j = 0; j < tmp_seq.length; ++j) {
                    found.put(tmp_seq[j], "");
                }
            }
        }
        org.omg.CORBA.Contained[] result = new org.omg.CORBA.Contained[found.size()];
        int idx = 0;
        Enumeration e = found.keys();
        while (e.hasMoreElements()) {
            result[idx++] = (org.omg.CORBA.Contained)e.nextElement();
        }
        return result;
    }

    public Description[] describe_contents(DefinitionKind limit_type, boolean exclude_inherited, int max_returned_objs) {
        return null;
    }

    public org.omg.CORBA.Contained[] contents(DefinitionKind limit_type, boolean exclude_inherited) {
        Hashtable<org.omg.CORBA.Contained, String> limited = new Hashtable<org.omg.CORBA.Contained, String>();
        Enumeration e = this.contained.elements();
        while (e.hasMoreElements()) {
            org.omg.CORBA.Contained c = (org.omg.CORBA.Contained)e.nextElement();
            if (limit_type != DefinitionKind.dk_all && limit_type != c.def_kind()) continue;
            limited.put(c, "");
        }
        org.omg.CORBA.Contained[] c = new org.omg.CORBA.Contained[limited.size()];
        Enumeration e2 = limited.keys();
        int i = 0;
        while (e2.hasMoreElements()) {
            c[i] = (org.omg.CORBA.Contained)e2.nextElement();
            ++i;
        }
        return c;
    }

    public org.omg.CORBA.ContainedPackage.Description describe() {
        if (!this.defined) {
            throw new INTF_REPOS("Struct " + this.full_name + " not defined! ");
        }
        Any a = this.orb.create_any();
        TypeDescription ed = this.describe_struct();
        TypeDescriptionHelper.insert(a, ed);
        return new org.omg.CORBA.ContainedPackage.Description(DefinitionKind.dk_Struct, a);
    }
}

