/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import java.util.Hashtable;
import org.jacorb.util.tracing.Request;
import org.jacorb.util.tracing.TraceData;
import org.jacorb.util.tracing.TraceTreeNode;
import org.jacorb.util.tracing.TracingServicePOA;
import org.jacorb.util.tracing.TracingServicePackage.NoSuchRequestId;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TracingServiceImpl
extends TracingServicePOA {
    private int pointIds = 0;
    private Hashtable traces = new Hashtable();

    public synchronized int get_id() {
        return this.pointIds++;
    }

    public TraceData getTrace(Request source) throws NoSuchRequestId {
        if (source.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - getTrace()");
            throw new NoSuchRequestId();
        }
        System.out.println("getTrace for tracer: " + source.originator + ", rid: " + source.rid);
        Long key = new Long(source.rid);
        TraceTreeNode t = (TraceTreeNode)this.traces.get(key);
        if (t == null) {
            return new TraceData(new TraceData[0], 0, "", 0L, 0L);
        }
        TraceData result = new TraceData(new TraceData[t.subtraces.size()], t.tracer_id, t.operation, t.client_time, t.server_time);
        for (int i = 0; i < t.subtraces.size(); ++i) {
            Request r = (Request)t.subtraces.elementAt(i);
            result.subtrace[i] = this.getTrace(r);
        }
        return result;
    }

    public void logTraceAtPoint(Request origin, String operation, long client_time, long server_time) throws NoSuchRequestId {
        if (origin.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - logTraceAtPoint()");
            throw new NoSuchRequestId();
        }
        System.out.println("logTraceAtPoint for tracer: " + origin.originator + ", rid: " + origin.rid);
        Long key = new Long(origin.rid);
        TraceTreeNode t = (TraceTreeNode)this.traces.get(key);
        if (t == null) {
            t = new TraceTreeNode(origin.originator);
            this.traces.put(key, t);
        }
        t.operation = operation;
        t.client_time = client_time;
        t.server_time = server_time;
    }

    public void registerSubTrace(Request original, Request nested) throws NoSuchRequestId {
        System.out.println("registerSubTrace for tracer: " + original.originator + ", rid: " + original.rid);
        if (original.originator >= this.pointIds || nested.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - registerSubTrace()");
            throw new NoSuchRequestId();
        }
        Long key = new Long(original.rid);
        TraceTreeNode t = (TraceTreeNode)this.traces.get(key);
        if (t == null) {
            t = new TraceTreeNode(original.originator);
            this.traces.put(key, t);
        }
        t.subtraces.addElement(nested);
    }

    public static void main(String[] args) {
        ORB orb = ORB.init(args, null);
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            Object o = poa.servant_to_reference(new TracingServiceImpl());
            NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));
            nc.bind(nc.to_name("tracing.service"), o);
            poa.the_POAManager().activate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orb.run();
    }
}

