/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

class TransactionHelper {
    private final TransactionManager transactionManager;

    TransactionHelper(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSuspendingTx(Operation op) {
        Transaction transaction = this.suspend();
        try {
            op.execute();
        }
        finally {
            this.resume(transaction);
        }
    }

    Transaction suspend() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            return this.transactionManager.suspend();
        }
        catch (Exception exception) {
            return null;
        }
    }

    void resume(Transaction transaction) {
        if (transaction == null || this.transactionManager == null) {
            return;
        }
        try {
            this.transactionManager.resume(transaction);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface Operation {
        public void execute();
    }
}

