/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.AbstractHandlerDefinition;
import org.wildfly.extension.undertow.UndertowMessages;
import org.wildfly.extension.undertow.filters.FilterAdd;

abstract class Filter
extends AbstractHandlerDefinition {
    private String name;

    protected Filter(String name) {
        super(name, "filter");
        this.name = name;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        FilterAdd add = new FilterAdd(this);
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    @Override
    public String getXmlElementName() {
        return this.name;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>(this.getAttributes());
        HttpHandler handler = Filter.createHandler(this.getHandlerClass(), model, attributes, next);
        if (predicate != null) {
            return Handlers.predicate((Predicate)predicate, (HttpHandler)handler, (HttpHandler)next);
        }
        return handler;
    }

    protected static HttpHandler createHandler(Class<? extends HttpHandler> handlerClass, ModelNode model, List<AttributeDefinition> attributes, HttpHandler next) {
        int numOfParams = attributes.size();
        if (next != null) {
            ++numOfParams;
        }
        try {
            for (Constructor<?> c : handlerClass.getDeclaredConstructors()) {
                if (c.getParameterTypes().length != numOfParams) continue;
                Object[] params = new Object[numOfParams];
                Class<?>[] parameterTypes = c.getParameterTypes();
                int attrCounter = 0;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> param = parameterTypes[i];
                    if (param == String.class) {
                        params[i] = model.get(attributes.get(attrCounter).getName()).asString();
                        ++attrCounter;
                        continue;
                    }
                    if (param == Integer.class || param == Integer.TYPE) {
                        params[i] = model.get(attributes.get(attrCounter).getName()).asInt();
                        ++attrCounter;
                        continue;
                    }
                    if (param == Long.class || param == Long.TYPE) {
                        params[i] = model.get(attributes.get(attrCounter).getName()).asLong();
                        ++attrCounter;
                        continue;
                    }
                    if (param != HttpHandler.class) continue;
                    params[i] = next;
                }
                return (HttpHandler)c.newInstance(params);
            }
        }
        catch (Throwable e) {
            throw UndertowMessages.MESSAGES.cannotCreateHttpHandler(handlerClass, model, e);
        }
        throw UndertowMessages.MESSAGES.cannotCreateHttpHandler(handlerClass, model, null);
    }
}

