/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazyMap;
import org.opensaml.xml.util.LazySet;

public class NamespaceManager {
    public static final String DEFAULT_NS_TOKEN = "#default";
    private static final Namespace XML_NAMESPACE = new Namespace("http://www.w3.org/XML/1998/namespace", "xml");
    private static final Namespace XSI_NAMESPACE = new Namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
    private XMLObject owner;
    private Namespace elementName;
    private Namespace elementType;
    private Set<Namespace> decls;
    private Set<Namespace> usage;
    private Set<Namespace> attrNames;
    private Map<String, Namespace> attrValues;
    private Namespace contentValue;

    public NamespaceManager(XMLObject owningObject) {
        this.owner = owningObject;
        this.decls = new LazySet<Namespace>();
        this.usage = new LazySet<Namespace>();
        this.attrNames = new LazySet<Namespace>();
        this.attrValues = new LazyMap<String, Namespace>();
    }

    public static String generateAttributeID(QName name) {
        return name.toString();
    }

    public XMLObject getOwner() {
        return this.owner;
    }

    public Set<Namespace> getNamespaces() {
        Set<Namespace> namespaces = this.mergeNamespaceCollections(this.decls, this.usage, this.attrNames, this.attrValues.values());
        this.addNamespace(namespaces, this.getElementNameNamespace());
        this.addNamespace(namespaces, this.getElementTypeNamespace());
        this.addNamespace(namespaces, this.contentValue);
        return namespaces;
    }

    public void registerNamespace(Namespace namespace) {
        this.addNamespace(this.usage, namespace);
    }

    public void deregisterNamespace(Namespace namespace) {
        this.removeNamespace(this.usage, namespace);
    }

    public void registerNamespaceDeclaration(Namespace namespace) {
        namespace.setAlwaysDeclare(true);
        this.addNamespace(this.decls, namespace);
    }

    public void deregisterNamespaceDeclaration(Namespace namespace) {
        this.removeNamespace(this.decls, namespace);
    }

    public void registerAttributeName(QName attributeName) {
        if (this.checkQName(attributeName)) {
            this.addNamespace(this.attrNames, this.buildNamespace(attributeName));
        }
    }

    public void deregisterAttributeName(QName attributeName) {
        if (this.checkQName(attributeName)) {
            this.removeNamespace(this.attrNames, this.buildNamespace(attributeName));
        }
    }

    public void registerAttributeValue(String attributeID, QName attributeValue) {
        if (this.checkQName(attributeValue)) {
            this.attrValues.put(attributeID, this.buildNamespace(attributeValue));
        }
    }

    public void deregisterAttributeValue(String attributeID) {
        this.attrValues.remove(attributeID);
    }

    public void registerContentValue(QName content) {
        if (this.checkQName(content)) {
            this.contentValue = this.buildNamespace(content);
        }
    }

    public void deregisterContentValue() {
        this.contentValue = null;
    }

    public Set<String> getNonVisibleNamespacePrefixes() {
        LazySet<String> prefixes = new LazySet<String>();
        this.addPrefixes(prefixes, this.getNonVisibleNamespaces());
        return prefixes;
    }

    public Set<Namespace> getNonVisibleNamespaces() {
        LazySet<Namespace> nonVisibleCandidates = new LazySet<Namespace>();
        List<XMLObject> children = this.getOwner().getOrderedChildren();
        if (children != null) {
            for (XMLObject child : this.getOwner().getOrderedChildren()) {
                Set<Namespace> childNonVisibleNamespaces;
                if (child == null || (childNonVisibleNamespaces = child.getNamespaceManager().getNonVisibleNamespaces()) == null || childNonVisibleNamespaces.isEmpty()) continue;
                nonVisibleCandidates.addAll((Collection<Namespace>)childNonVisibleNamespaces);
            }
        }
        nonVisibleCandidates.addAll((Collection<Namespace>)this.getNonVisibleNamespaceCandidates());
        nonVisibleCandidates.removeAll(this.getVisibleNamespaces());
        nonVisibleCandidates.remove(XML_NAMESPACE);
        return nonVisibleCandidates;
    }

    public Set<Namespace> getAllNamespacesInSubtreeScope() {
        LazySet<Namespace> namespaces = new LazySet<Namespace>();
        List<XMLObject> children = this.getOwner().getOrderedChildren();
        if (children != null) {
            for (XMLObject child : this.getOwner().getOrderedChildren()) {
                Set<Namespace> childNamespaces;
                if (child == null || (childNamespaces = child.getNamespaceManager().getAllNamespacesInSubtreeScope()) == null || childNamespaces.isEmpty()) continue;
                namespaces.addAll((Collection<Namespace>)childNamespaces);
            }
        }
        for (Namespace myNS : this.getNamespaces()) {
            namespaces.add(this.copyNamespace(myNS));
        }
        return namespaces;
    }

    public void registerElementName(QName name) {
        if (this.checkQName(name)) {
            this.elementName = this.buildNamespace(name);
        }
    }

    public void registerElementType(QName type) {
        if (type != null) {
            if (this.checkQName(type)) {
                this.elementType = this.buildNamespace(type);
            }
        } else {
            this.elementType = null;
        }
    }

    private Namespace getElementNameNamespace() {
        if (this.elementName == null && this.checkQName(this.owner.getElementQName())) {
            this.elementName = this.buildNamespace(this.owner.getElementQName());
        }
        return this.elementName;
    }

    private Namespace getElementTypeNamespace() {
        QName type;
        if (this.elementType == null && (type = this.owner.getSchemaType()) != null && this.checkQName(type)) {
            this.elementType = this.buildNamespace(type);
        }
        return this.elementType;
    }

    private Namespace buildNamespace(QName name) {
        String uri = DatatypeHelper.safeTrimOrNullString(name.getNamespaceURI());
        if (uri == null) {
            throw new IllegalArgumentException("A non-empty namespace URI must be supplied");
        }
        String prefix = DatatypeHelper.safeTrimOrNullString(name.getPrefix());
        return new Namespace(uri, prefix);
    }

    private void addNamespace(Set<Namespace> namespaces, Namespace newNamespace) {
        if (newNamespace == null) {
            return;
        }
        if (namespaces.size() == 0) {
            namespaces.add(newNamespace);
            return;
        }
        for (Namespace namespace : namespaces) {
            if (!DatatypeHelper.safeEquals(namespace.getNamespaceURI(), newNamespace.getNamespaceURI()) || !DatatypeHelper.safeEquals(namespace.getNamespacePrefix(), newNamespace.getNamespacePrefix())) continue;
            if (newNamespace.alwaysDeclare() && !namespace.alwaysDeclare()) {
                namespaces.remove(namespace);
                namespaces.add(newNamespace);
                return;
            }
            return;
        }
        namespaces.add(newNamespace);
    }

    private void removeNamespace(Set<Namespace> namespaces, Namespace oldNamespace) {
        if (oldNamespace == null) {
            return;
        }
        Iterator<Namespace> iter = namespaces.iterator();
        while (iter.hasNext()) {
            Namespace namespace = iter.next();
            if (!DatatypeHelper.safeEquals(namespace.getNamespaceURI(), oldNamespace.getNamespaceURI()) || !DatatypeHelper.safeEquals(namespace.getNamespacePrefix(), oldNamespace.getNamespacePrefix())) continue;
            iter.remove();
        }
    }

    private Set<Namespace> mergeNamespaceCollections(Collection<Namespace> ... namespaces) {
        LazySet<Namespace> newNamespaces = new LazySet<Namespace>();
        for (Collection<Namespace> nsCollection : namespaces) {
            for (Namespace ns : nsCollection) {
                if (ns == null) continue;
                this.addNamespace(newNamespaces, ns);
            }
        }
        return newNamespaces;
    }

    private Set<Namespace> getVisibleNamespaces() {
        LazySet<Namespace> namespaces = new LazySet<Namespace>();
        if (this.getElementNameNamespace() != null) {
            namespaces.add(this.copyNamespace(this.getElementNameNamespace()));
        }
        if (this.getElementTypeNamespace() != null) {
            namespaces.add(this.copyNamespace(XSI_NAMESPACE));
        }
        for (Namespace attribName : this.attrNames) {
            if (attribName == null) continue;
            namespaces.add(this.copyNamespace(attribName));
        }
        return namespaces;
    }

    private Set<Namespace> getNonVisibleNamespaceCandidates() {
        LazySet<Namespace> namespaces = new LazySet<Namespace>();
        if (this.getElementTypeNamespace() != null) {
            namespaces.add(this.copyNamespace(this.getElementTypeNamespace()));
        }
        for (Namespace attribValue : this.attrValues.values()) {
            if (attribValue == null) continue;
            namespaces.add(this.copyNamespace(attribValue));
        }
        if (this.contentValue != null) {
            namespaces.add(this.copyNamespace(this.contentValue));
        }
        return namespaces;
    }

    private Namespace copyNamespace(Namespace orig) {
        if (orig == null) {
            return null;
        }
        return new Namespace(orig.getNamespaceURI(), orig.getNamespacePrefix());
    }

    private void addPrefixes(Set<String> prefixes, Collection<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            String prefix = DatatypeHelper.safeTrimOrNullString(ns.getNamespacePrefix());
            if (prefix == null) {
                prefix = DEFAULT_NS_TOKEN;
            }
            prefixes.add(prefix);
        }
    }

    private boolean checkQName(QName name) {
        return !DatatypeHelper.isEmpty(name.getNamespaceURI());
    }
}

