/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ParameterMode;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.AbstractBasicQueryContractImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.NoSuchParameterException;
import org.hibernate.procedure.ParameterRegistration;
import org.hibernate.procedure.ParameterStrategyException;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.ProcedureOutputs;
import org.hibernate.procedure.internal.AbstractParameterRegistrationImpl;
import org.hibernate.procedure.internal.NamedParameterRegistration;
import org.hibernate.procedure.internal.PositionalParameterRegistration;
import org.hibernate.procedure.internal.ProcedureCallMementoImpl;
import org.hibernate.procedure.internal.ProcedureOutputsImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.ParameterRegistrationImplementor;
import org.hibernate.procedure.spi.ParameterStrategy;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class ProcedureCallImpl
extends AbstractBasicQueryContractImpl
implements ProcedureCall,
ResultContext {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)ProcedureCallImpl.class.getName());
    private static final NativeSQLQueryReturn[] NO_RETURNS = new NativeSQLQueryReturn[0];
    private final String procedureName;
    private final NativeSQLQueryReturn[] queryReturns;
    private ParameterStrategy parameterStrategy = ParameterStrategy.UNKNOWN;
    private List<ParameterRegistrationImplementor<?>> registeredParameters = new ArrayList();
    private Set<String> synchronizedQuerySpaces;
    private ProcedureOutputsImpl outputs;

    public ProcedureCallImpl(SessionImplementor session, String procedureName) {
        super(session);
        this.procedureName = procedureName;
        this.queryReturns = NO_RETURNS;
    }

    public ProcedureCallImpl(final SessionImplementor session, String procedureName, Class ... resultClasses) {
        super(session);
        this.procedureName = procedureName;
        final ArrayList collectedQueryReturns = new ArrayList();
        final HashSet<String> collectedQuerySpaces = new HashSet<String>();
        Util.resolveResultClasses(new Util.ResultClassesResolutionContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return session.getFactory();
            }

            @Override
            public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                Collections.addAll(collectedQueryReturns, queryReturns);
            }

            @Override
            public void addQuerySpaces(String ... spaces) {
                Collections.addAll(collectedQuerySpaces, spaces);
            }
        }, resultClasses);
        this.queryReturns = collectedQueryReturns.toArray(new NativeSQLQueryReturn[collectedQueryReturns.size()]);
        this.synchronizedQuerySpaces = collectedQuerySpaces;
    }

    public ProcedureCallImpl(final SessionImplementor session, String procedureName, String ... resultSetMappings) {
        super(session);
        this.procedureName = procedureName;
        final ArrayList collectedQueryReturns = new ArrayList();
        final HashSet<String> collectedQuerySpaces = new HashSet<String>();
        Util.resolveResultSetMappings(new Util.ResultSetMappingResolutionContext(){

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return session.getFactory();
            }

            @Override
            public ResultSetMappingDefinition findResultSetMapping(String name) {
                return session.getFactory().getResultSetMapping(name);
            }

            @Override
            public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                Collections.addAll(collectedQueryReturns, queryReturns);
            }

            @Override
            public void addQuerySpaces(String ... spaces) {
                Collections.addAll(collectedQuerySpaces, spaces);
            }
        }, resultSetMappings);
        this.queryReturns = collectedQueryReturns.toArray(new NativeSQLQueryReturn[collectedQueryReturns.size()]);
        this.synchronizedQuerySpaces = collectedQuerySpaces;
    }

    ProcedureCallImpl(SessionImplementor session, ProcedureCallMementoImpl memento) {
        super(session);
        this.procedureName = memento.getProcedureName();
        this.queryReturns = memento.getQueryReturns();
        this.synchronizedQuerySpaces = Util.copy(memento.getSynchronizedQuerySpaces());
        this.parameterStrategy = memento.getParameterStrategy();
        if (this.parameterStrategy == ParameterStrategy.UNKNOWN) {
            return;
        }
        List<ProcedureCallMementoImpl.ParameterMemento> storedRegistrations = memento.getParameterDeclarations();
        if (storedRegistrations == null) {
            LOG.debugf("ParameterStrategy was [%s] on named copy [%s], but no parameters stored", (Object)this.parameterStrategy, this.procedureName);
            return;
        }
        List parameterRegistrations = CollectionHelper.arrayList(storedRegistrations.size());
        for (ProcedureCallMementoImpl.ParameterMemento storedRegistration : storedRegistrations) {
            AbstractParameterRegistrationImpl registration;
            if (StringHelper.isNotEmpty(storedRegistration.getName())) {
                if (this.parameterStrategy != ParameterStrategy.NAMED) {
                    throw new IllegalStateException("Found named stored procedure parameter associated with positional parameters");
                }
                registration = new NamedParameterRegistration(this, storedRegistration.getName(), storedRegistration.getMode(), storedRegistration.getType(), storedRegistration.getHibernateType());
            } else {
                if (this.parameterStrategy != ParameterStrategy.POSITIONAL) {
                    throw new IllegalStateException("Found named stored procedure parameter associated with positional parameters");
                }
                registration = new PositionalParameterRegistration(this, storedRegistration.getPosition(), storedRegistration.getMode(), storedRegistration.getType(), storedRegistration.getHibernateType());
            }
            parameterRegistrations.add(registration);
        }
        this.registeredParameters = parameterRegistrations;
    }

    @Override
    public SessionImplementor getSession() {
        return super.session();
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    @Override
    public String getProcedureName() {
        return this.procedureName;
    }

    @Override
    public String getSql() {
        return this.getProcedureName();
    }

    @Override
    public NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns;
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(int position, Class<T> type, ParameterMode mode) {
        PositionalParameterRegistration<T> parameterRegistration = new PositionalParameterRegistration<T>(this, position, mode, type);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(int position, Class type, ParameterMode mode) {
        this.registerParameter(position, type, mode);
        return this;
    }

    private void registerParameter(ParameterRegistrationImplementor parameter) {
        if (StringHelper.isNotEmpty(parameter.getName())) {
            this.prepareForNamedParameters();
        } else if (parameter.getPosition() != null) {
            this.prepareForPositionalParameters();
        } else {
            throw new IllegalArgumentException("Given parameter did not define name or position [" + parameter + "]");
        }
        this.registeredParameters.add(parameter);
    }

    private void prepareForPositionalParameters() {
        if (this.parameterStrategy == ParameterStrategy.NAMED) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        this.parameterStrategy = ParameterStrategy.POSITIONAL;
    }

    private void prepareForNamedParameters() {
        if (this.parameterStrategy == ParameterStrategy.POSITIONAL) {
            throw new QueryException("Cannot mix named and positional parameters");
        }
        if (this.parameterStrategy == ParameterStrategy.UNKNOWN) {
            ExtractedDatabaseMetaData databaseMetaData = this.getSession().getTransactionCoordinator().getJdbcCoordinator().getLogicalConnection().getJdbcServices().getExtractedMetaDataSupport();
            if (!databaseMetaData.supportsNamedParameters()) {
                LOG.unsupportedNamedParameters();
            }
            this.parameterStrategy = ParameterStrategy.NAMED;
        }
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(int position) {
        if (this.parameterStrategy != ParameterStrategy.POSITIONAL) {
            throw new ParameterStrategyException("Attempt to access positional parameter [" + position + "] but ProcedureCall using named parameters");
        }
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            if (position != parameter.getPosition()) continue;
            return parameter;
        }
        throw new NoSuchParameterException("Could not locate parameter registered using that position [" + position + "]");
    }

    @Override
    public <T> ParameterRegistration<T> registerParameter(String name, Class<T> type, ParameterMode mode) {
        NamedParameterRegistration<T> parameterRegistration = new NamedParameterRegistration<T>(this, name, mode, type);
        this.registerParameter(parameterRegistration);
        return parameterRegistration;
    }

    @Override
    public ProcedureCall registerParameter0(String name, Class type, ParameterMode mode) {
        this.registerParameter(name, type, mode);
        return this;
    }

    @Override
    public ParameterRegistrationImplementor getParameterRegistration(String name) {
        if (this.parameterStrategy != ParameterStrategy.NAMED) {
            throw new ParameterStrategyException("Names were not used to register parameters with this stored procedure call");
        }
        for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        throw new NoSuchParameterException("Could not locate parameter registered under that name [" + name + "]");
    }

    @Override
    public List<ParameterRegistration> getRegisteredParameters() {
        return new ArrayList<ParameterRegistration>(this.registeredParameters);
    }

    @Override
    public ProcedureOutputs getOutputs() {
        if (this.outputs == null) {
            this.outputs = this.buildOutputs();
        }
        return this.outputs;
    }

    private ProcedureOutputsImpl buildOutputs() {
        String call = this.session().getFactory().getDialect().getCallableStatementSupport().renderCallableStatement(this.procedureName, this.parameterStrategy, this.registeredParameters, this.session());
        try {
            CallableStatement statement = (CallableStatement)this.getSession().getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(call, true);
            int i = 1;
            for (ParameterRegistrationImplementor<?> parameter : this.registeredParameters) {
                parameter.prepare(statement, i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    ++i;
                    continue;
                }
                i += parameter.getSqlTypes().length;
            }
            return new ProcedureOutputsImpl(this, statement);
        }
        catch (SQLException e) {
            throw this.getSession().getFactory().getSQLExceptionHelper().convert(e, "Error preparing CallableStatement", this.getProcedureName());
        }
    }

    @Override
    public Type[] getReturnTypes() throws HibernateException {
        throw new NotYetImplementedException();
    }

    protected Set<String> synchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            this.synchronizedQuerySpaces = new HashSet<String>();
        }
        return this.synchronizedQuerySpaces;
    }

    @Override
    public Set<String> getSynchronizedQuerySpaces() {
        if (this.synchronizedQuerySpaces == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.synchronizedQuerySpaces);
    }

    @Override
    public ProcedureCallImpl addSynchronizedQuerySpace(String querySpace) {
        this.synchronizedQuerySpaces().add(querySpace);
        return this;
    }

    @Override
    public ProcedureCallImpl addSynchronizedEntityName(String entityName) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getEntityPersister(entityName));
        return this;
    }

    protected void addSynchronizedQuerySpaces(EntityPersister persister) {
        this.synchronizedQuerySpaces().addAll(Arrays.asList((String[])persister.getQuerySpaces()));
    }

    @Override
    public ProcedureCallImpl addSynchronizedEntityClass(Class entityClass) {
        this.addSynchronizedQuerySpaces(this.getSession().getFactory().getEntityPersister(entityClass.getName()));
        return this;
    }

    @Override
    public QueryParameters getQueryParameters() {
        return this.buildQueryParametersObject();
    }

    @Override
    public QueryParameters buildQueryParametersObject() {
        QueryParameters qp = super.buildQueryParametersObject();
        qp.setAutoDiscoverScalarTypes(true);
        qp.setCallable(true);
        return qp;
    }

    public ParameterRegistrationImplementor[] collectRefCursorParameters() {
        ArrayList refCursorParams = new ArrayList();
        for (ParameterRegistrationImplementor<?> param : this.registeredParameters) {
            if (param.getMode() != ParameterMode.REF_CURSOR) continue;
            refCursorParams.add(param);
        }
        return refCursorParams.toArray(new ParameterRegistrationImplementor[refCursorParams.size()]);
    }

    @Override
    public ProcedureCallMemento extractMemento(Map<String, Object> hints) {
        return new ProcedureCallMementoImpl(this.procedureName, Util.copy(this.queryReturns), this.parameterStrategy, ProcedureCallImpl.toParameterMementos(this.registeredParameters), Util.copy(this.synchronizedQuerySpaces), Util.copy(hints));
    }

    private static List<ProcedureCallMementoImpl.ParameterMemento> toParameterMementos(List<ParameterRegistrationImplementor<?>> registeredParameters) {
        if (registeredParameters == null) {
            return null;
        }
        List<ProcedureCallMementoImpl.ParameterMemento> copy = CollectionHelper.arrayList(registeredParameters.size());
        for (ParameterRegistrationImplementor<?> registration : registeredParameters) {
            copy.add(ProcedureCallMementoImpl.ParameterMemento.fromRegistration(registration));
        }
        return copy;
    }
}

