/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class bla4 {
    protected static Map<Address, PhysicalAddress> map = new HashMap<Address, PhysicalAddress>();

    public static void main(String[] args) throws Exception {
        String host1 = "192.168.1.5";
        String host2 = "192.168.1.2";
        String host3 = "127.0.0.1";
        Address a = Util.createRandomAddress("A");
        Address b = Util.createRandomAddress("B");
        Address c = Util.createRandomAddress("C");
        Address d = Util.createRandomAddress("D");
        Address e = Util.createRandomAddress("E");
        Address f = Util.createRandomAddress("F");
        Address x = Util.createRandomAddress("X");
        Address y = Util.createRandomAddress("Y");
        Address z = Util.createRandomAddress("Z");
        map.put(a, new IpAddress(host1, 5000));
        map.put(b, new IpAddress(host1, 64773));
        map.put(c, new IpAddress(host1, 6663));
        map.put(d, new IpAddress(host2, 5000));
        map.put(e, new IpAddress(host2, 6000));
        map.put(f, new IpAddress(host2, 45454));
        map.put(x, new IpAddress(host3, 1));
        map.put(y, new IpAddress(host3, 2));
        map.put(z, new IpAddress(host3, 3));
        View view = View.create(a, 1L, a, b, c, d, e, f, x, y, z);
        Map<InetAddress, SortedSet<Address>> result = bla4.getMap(view);
        Set<InetAddress> keys = result.keySet();
        System.out.println("keys = " + keys);
        result.clear();
        System.out.println("keys = " + keys);
    }

    protected static Map<InetAddress, SortedSet<Address>> getMap(View view) {
        ConcurrentHashMap<InetAddress, SortedSet<Address>> map = new ConcurrentHashMap<InetAddress, SortedSet<Address>>();
        for (Address mbr : view) {
            InetAddress key = bla4.getHostFor(mbr);
            if (key == null) continue;
            TreeSet<Address> mbrs = (TreeSet<Address>)map.get(key);
            if (mbrs == null) {
                mbrs = new TreeSet<Address>();
                map.put(key, mbrs);
            }
            mbrs.add(mbr);
        }
        return map;
    }

    protected static PhysicalAddress getPhysicalAddress(Address logical_addr) {
        return map.get(logical_addr);
    }

    protected static InetAddress getHostFor(Address mbr) {
        PhysicalAddress phys_addr = bla4.getPhysicalAddress(mbr);
        return phys_addr instanceof IpAddress ? ((IpAddress)phys_addr).getIpAddress() : null;
    }
}

