/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SharingBufferReaderProvider
implements DirectoryBasedReaderProvider {
    private static final Log log = LoggerFactory.make();
    protected final Map<IndexReader, ReaderUsagePair> allReaders = new ConcurrentHashMap<IndexReader, ReaderUsagePair>();
    protected final Map<Directory, PerDirectoryLatestReader> currentReaders = new ConcurrentHashMap<Directory, PerDirectoryLatestReader>();
    private volatile int refreshOperationId = 0;
    private DirectoryProvider directoryProvider;
    private String indexName;

    public DirectoryReader openIndexReader() {
        log.debugf("Opening IndexReader for directoryProvider %s", this.indexName);
        Object directory = this.directoryProvider.getDirectory();
        PerDirectoryLatestReader directoryLatestReader = this.currentReaders.get(directory);
        if (directoryLatestReader == null) {
            directoryLatestReader = this.createReader((Directory)directory);
        }
        return directoryLatestReader.refreshAndGet();
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        if (reader == null) {
            return;
        }
        log.debugf("Closing IndexReader: %s", reader);
        ReaderUsagePair container = this.allReaders.get(reader);
        container.close();
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
        this.directoryProvider = indexManager.getDirectoryProvider();
        this.indexName = indexManager.getIndexName();
        this.createReader((Directory)this.directoryProvider.getDirectory());
    }

    private synchronized PerDirectoryLatestReader createReader(Directory directory) {
        PerDirectoryLatestReader reader = this.currentReaders.get(directory);
        if (reader != null) {
            return reader;
        }
        try {
            reader = new PerDirectoryLatestReader(directory);
            this.currentReaders.put(directory, reader);
            return reader;
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader for IndexManager " + this.indexName, e);
        }
    }

    @Override
    public void stop() {
        for (IndexReader reader : this.allReaders.keySet()) {
            ReaderUsagePair usage = this.allReaders.get(reader);
            usage.close();
        }
        if (this.allReaders.size() != 0) {
            log.readersNotProperlyClosedInReaderProvider();
        }
    }

    protected DirectoryReader readerFactory(Directory directory) throws IOException {
        return DirectoryReader.open((Directory)directory);
    }

    protected final class PerDirectoryLatestReader {
        public ReaderUsagePair current;
        private final Lock lockOnReplaceCurrent = new ReentrantLock();

        public PerDirectoryLatestReader(Directory directory) throws IOException {
            DirectoryReader reader = SharingBufferReaderProvider.this.readerFactory(directory);
            ReaderUsagePair initialPair = new ReaderUsagePair(reader);
            initialPair.usageCounter.set(1);
            this.lockOnReplaceCurrent.lock();
            this.current = initialPair;
            this.lockOnReplaceCurrent.unlock();
            SharingBufferReaderProvider.this.allReaders.put((IndexReader)reader, initialPair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DirectoryReader refreshAndGet() {
            DirectoryReader updatedReader;
            int preAcquireVersionId = SharingBufferReaderProvider.this.refreshOperationId;
            ReaderUsagePair toCloseReaderPair = null;
            this.lockOnReplaceCurrent.lock();
            DirectoryReader beforeUpdateReader = this.current.reader;
            try {
                if (SharingBufferReaderProvider.this.refreshOperationId != preAcquireVersionId) {
                    this.current.usageCounter.incrementAndGet();
                    DirectoryReader directoryReader = beforeUpdateReader;
                    return directoryReader;
                }
                try {
                    SharingBufferReaderProvider.this.refreshOperationId++;
                    updatedReader = DirectoryReader.openIfChanged((DirectoryReader)beforeUpdateReader);
                }
                catch (IOException e) {
                    throw new SearchException("Unable to reopen IndexReader", e);
                }
                if (updatedReader == null) {
                    this.current.usageCounter.incrementAndGet();
                    DirectoryReader e = beforeUpdateReader;
                    return e;
                }
                ReaderUsagePair newPair = new ReaderUsagePair(updatedReader);
                assert (newPair.usageCounter.get() == 2);
                toCloseReaderPair = this.current;
                this.current = newPair;
                SharingBufferReaderProvider.this.allReaders.put((IndexReader)updatedReader, newPair);
            }
            finally {
                this.lockOnReplaceCurrent.unlock();
            }
            if (toCloseReaderPair != null) {
                toCloseReaderPair.close();
            }
            return updatedReader;
        }
    }

    protected final class ReaderUsagePair {
        public final DirectoryReader reader;
        protected final AtomicInteger usageCounter = new AtomicInteger(2);

        ReaderUsagePair(DirectoryReader r) {
            this.reader = r;
        }

        public void close() {
            int refCount = this.usageCounter.decrementAndGet();
            if (refCount == 0) {
                ReaderUsagePair removed = SharingBufferReaderProvider.this.allReaders.remove(this.reader);
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    log.unableToCloseLuceneIndexReader(e);
                }
                assert (removed != null);
            } else if (refCount < 0) {
                throw new AssertionFailure("Closing an IndexReader for which you didn't own a lock-token, or somebody else which didn't own closed already.");
            }
        }

        public String toString() {
            return "Reader:" + this.hashCode() + " ref.count=" + this.usageCounter.get();
        }
    }
}

