/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.clustering.infinispan.invoker.Mutator;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.Time;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanRemover;
import org.wildfly.clustering.ejb.infinispan.InfinispanEjbLogger;

public class InfinispanBean<G, I, T>
implements Bean<G, I, T> {
    private final I id;
    private final BeanEntry<G> entry;
    private final BeanGroup<G, I, T> group;
    private final Mutator mutator;
    private final BeanRemover<I, T> remover;
    private final Time timeout;
    private final PassivationListener<T> listener;
    private final AtomicBoolean valid = new AtomicBoolean(true);

    public InfinispanBean(I id, BeanEntry<G> entry, BeanGroup<G, I, T> group, Mutator mutator, BeanRemover<I, T> remover, Time timeout, PassivationListener<T> listener) {
        this.id = id;
        this.entry = entry;
        this.group = group;
        this.mutator = mutator;
        this.remover = remover;
        this.timeout = timeout;
        this.listener = listener;
    }

    public I getId() {
        return this.id;
    }

    public G getGroupId() {
        return this.entry.getGroupId();
    }

    public boolean isExpired() {
        if (this.timeout == null) {
            return false;
        }
        Date lastAccessedTime = this.entry.getLastAccessedTime();
        long timeout = this.timeout.convert(TimeUnit.MILLISECONDS);
        return lastAccessedTime != null && timeout > 0L ? System.currentTimeMillis() - lastAccessedTime.getTime() >= timeout : false;
    }

    public void remove(RemoveListener<T> listener) {
        if (this.valid.compareAndSet(true, false)) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Removing bean %s", this.id);
            this.remover.remove(this.id, listener);
            this.close();
        }
    }

    public T acquire() {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Acquiring reference to bean %s", this.id);
        return this.group.getBean(this.id, this.listener);
    }

    public boolean release() {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Releasing reference to bean %s", this.id);
        return this.group.releaseBean(this.id, this.listener);
    }

    public void close() {
        if (this.valid.get()) {
            Date lastAccessedTime = this.entry.getLastAccessedTime();
            this.entry.setLastAccessedTime(new Date());
            if (lastAccessedTime != null) {
                this.mutator.mutate();
            }
        }
        if (this.group.isCloseable()) {
            this.group.close();
        }
    }
}

