/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.util.AddServerWindow;
import org.jacorb.imr.util.ConnectWindow;
import org.jacorb.imr.util.ImRModel;
import org.jacorb.imr.util.ImRTableCellEditor;
import org.jacorb.imr.util.ImRTreeCellRenderer;
import org.jacorb.imr.util.RefreshWindow;

public class ImRManagerGUI
extends JFrame {
    private JMenuItem m_exit_mi;
    private JMenuItem m_about_mi;
    private JMenuItem m_refresh_all_mi;
    private JMenuItem m_connect_mi;
    private JMenuItem m_shutdown_mi;
    private JMenuItem m_forcedown_mi;
    private JMenuItem m_save_mi;
    private JMenuItem m_add_mi;
    private JMenuItem m_remove_mi;
    private JMenuItem m_hold_mi;
    private JMenuItem m_release_mi;
    private JMenuItem m_setdown_mi;
    private JMenuItem m_refresh_mi;
    private JMenuItem m_auto_refresh_mi;
    private EventHandler m_handler = new EventHandler();
    private ImRModel m_model = new ImRModel();
    private DefaultMutableTreeNode m_top_node;
    private JTree m_tree;
    private JPanel m_table_panel;
    private JScrollPane m_server_view;
    private JScrollPane m_poa_view;
    private JScrollPane m_tree_view;
    private JTable m_server_table;
    private JTable m_poa_table;
    private JPopupMenu m_context_menu;
    private JMenuItem m_add_cmi;
    private JMenuItem m_remove_cmi;
    private JMenuItem m_hold_cmi;
    private JMenuItem m_release_cmi;
    private JMenuItem m_setdown_cmi;
    private JMenuItem m_refresh_cmi;

    public ImRManagerGUI() {
        super("ImR Manager");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        GridBagConstraints _constraints = new GridBagConstraints();
        JMenuBar _menu_bar = new JMenuBar();
        this.setJMenuBar(_menu_bar);
        JMenu _manager_menu = new JMenu("Manager");
        _menu_bar.add(_manager_menu);
        JMenu _imr_menu = new JMenu("ImR");
        _menu_bar.add(_imr_menu);
        JMenu _server_menu = new JMenu("Server");
        _menu_bar.add(_server_menu);
        this.m_about_mi = new JMenuItem("About...");
        this.m_about_mi.addActionListener(this.m_handler);
        _manager_menu.add(this.m_about_mi);
        this.m_auto_refresh_mi = new JMenuItem("Automatic Refresh...");
        this.m_auto_refresh_mi.addActionListener(this.m_handler);
        _manager_menu.add(this.m_auto_refresh_mi);
        this.m_exit_mi = new JMenuItem("Exit");
        this.m_exit_mi.addActionListener(this.m_handler);
        _manager_menu.add(this.m_exit_mi);
        this.m_shutdown_mi = new JMenuItem("Shutdown");
        this.m_shutdown_mi.addActionListener(this.m_handler);
        _imr_menu.add(this.m_shutdown_mi);
        this.m_forcedown_mi = new JMenuItem("Force Down");
        this.m_forcedown_mi.addActionListener(this.m_handler);
        _imr_menu.add(this.m_forcedown_mi);
        this.m_save_mi = new JMenuItem("Save Server Table");
        this.m_save_mi.addActionListener(this.m_handler);
        _imr_menu.add(this.m_save_mi);
        _imr_menu.addSeparator();
        this.m_connect_mi = new JMenuItem("Connect...");
        this.m_connect_mi.addActionListener(this.m_handler);
        _imr_menu.add(this.m_connect_mi);
        this.m_refresh_all_mi = new JMenuItem("Refresh all");
        this.m_refresh_all_mi.addActionListener(this.m_handler);
        _imr_menu.add(this.m_refresh_all_mi);
        this.m_add_mi = new JMenuItem("Add...");
        this.m_add_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_add_mi);
        this.m_remove_mi = new JMenuItem("Remove");
        this.m_remove_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_remove_mi);
        this.m_hold_mi = new JMenuItem("Hold");
        this.m_hold_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_hold_mi);
        this.m_release_mi = new JMenuItem("Release");
        this.m_release_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_release_mi);
        this.m_setdown_mi = new JMenuItem("Set Down");
        this.m_setdown_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_setdown_mi);
        _server_menu.addSeparator();
        this.m_refresh_mi = new JMenuItem("Refresh");
        this.m_refresh_mi.addActionListener(this.m_handler);
        _server_menu.add(this.m_refresh_mi);
        this.m_context_menu = new JPopupMenu("Server manipulation");
        this.m_context_menu.setVisible(true);
        this.m_add_cmi = new JMenuItem("Add...");
        this.m_add_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_add_cmi);
        this.m_remove_cmi = new JMenuItem("Remove");
        this.m_remove_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_remove_cmi);
        this.m_context_menu.addSeparator();
        this.m_hold_cmi = new JMenuItem("Hold");
        this.m_hold_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_hold_cmi);
        this.m_release_cmi = new JMenuItem("Release");
        this.m_release_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_release_cmi);
        this.m_setdown_cmi = new JMenuItem("Set Down");
        this.m_setdown_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_setdown_cmi);
        this.m_context_menu.addSeparator();
        this.m_refresh_cmi = new JMenuItem("Refresh");
        this.m_refresh_cmi.addActionListener(this.m_handler);
        this.m_context_menu.add(this.m_refresh_cmi);
        JPanel _top_panel = new JPanel();
        GridBagLayout _top_gbl = new GridBagLayout();
        _top_panel.setLayout(_top_gbl);
        this.m_tree = this.m_model.getTree();
        this.m_tree.setEditable(false);
        this.m_tree.setCellRenderer(new ImRTreeCellRenderer());
        this.m_tree.addTreeSelectionListener(this.m_handler);
        this.m_tree.addMouseListener(this.m_handler);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        this.m_tree_view = new JScrollPane(this.m_tree);
        this.m_tree_view.addMouseListener(this.m_handler);
        this.m_table_panel = new JPanel();
        GridBagLayout _table_gbl = new GridBagLayout();
        this.m_table_panel.setLayout(_table_gbl);
        TableModel _server_model = this.m_model.getServerTableModel();
        this.m_server_table = new JTable(_server_model);
        this.m_server_table.addMouseListener(this.m_handler);
        ListSelectionModel _selection_model = this.m_server_table.getSelectionModel();
        _selection_model.addListSelectionListener(this.m_handler);
        TableColumn _host_col = this.m_server_table.getColumnModel().getColumn(1);
        _host_col.setCellEditor(new ImRTableCellEditor(this.m_model.getHostSelector()));
        this.m_server_view = new JScrollPane(this.m_server_table);
        this.m_server_view.setVisible(true);
        this.buildConstraints(_constraints, 0, 0, 1, 1, 1, 1);
        _constraints.fill = 1;
        _table_gbl.setConstraints(this.m_server_view, _constraints);
        this.m_table_panel.add(this.m_server_view);
        TableModel _poa_model = this.m_model.getPOATableModel();
        this.m_poa_table = new JTable(_poa_model);
        this.m_poa_view = new JScrollPane(this.m_poa_table);
        this.m_poa_view.setVisible(false);
        this.buildConstraints(_constraints, 0, 0, 1, 1, 1, 1);
        _constraints.fill = 1;
        _table_gbl.setConstraints(this.m_poa_view, _constraints);
        this.m_table_panel.add(this.m_poa_view);
        JSplitPane _split_pane = new JSplitPane(1, this.m_tree_view, this.m_table_panel);
        _split_pane.setOneTouchExpandable(true);
        _split_pane.setDividerLocation(150);
        this.buildConstraints(_constraints, 0, 0, 1, 1, 1, 1);
        _constraints.fill = 1;
        _top_gbl.setConstraints(_split_pane, _constraints);
        _top_panel.add(_split_pane);
        this.getContentPane().add(_top_panel);
        this.pack();
        this.setVisible(true);
    }

    private void showPOATable() {
        if (!this.m_poa_view.isVisible()) {
            this.m_server_view.setVisible(false);
            this.m_poa_view.setVisible(true);
            this.pack();
            this.m_table_panel.repaint();
        }
    }

    private void showServerTable() {
        if (!this.m_server_view.isVisible()) {
            this.m_poa_view.setVisible(false);
            this.m_server_view.setVisible(true);
            this.pack();
            this.m_table_panel.repaint();
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static void main(String[] args) {
        new ImRManagerGUI();
    }

    private class EventHandler
    implements MouseListener,
    ListSelectionListener,
    TreeSelectionListener,
    ActionListener,
    Serializable {
        private EventHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object _source = event.getSource();
            if (_source instanceof JMenuItem) {
                if ((JMenuItem)_source == ImRManagerGUI.this.m_exit_mi) {
                    System.exit(0);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_about_mi) {
                    JOptionPane.showMessageDialog(new JFrame(), "FUB - Institute for Computer Sciences\n\nThe man with the plan: Gerald Brose\nThe imp to get along with the plans: Nicolas Noffke\n");
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_auto_refresh_mi) {
                    new RefreshWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_refresh_all_mi) {
                    ImRManagerGUI.this.m_model.fetchServers();
                    ImRManagerGUI.this.showServerTable();
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_connect_mi) {
                    new ConnectWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_shutdown_mi) {
                    ImRManagerGUI.this.m_model.imrShutdown(true);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_forcedown_mi) {
                    ImRManagerGUI.this.m_model.imrShutdown(false);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_save_mi) {
                    ImRManagerGUI.this.m_model.saveTable();
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_add_mi || (JMenuItem)_source == ImRManagerGUI.this.m_add_cmi) {
                    new AddServerWindow(ImRManagerGUI.this.m_model);
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_remove_mi || (JMenuItem)_source == ImRManagerGUI.this.m_remove_cmi) {
                    int _select = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (_select > -1) {
                        ImRManagerGUI.this.m_model.removeServer(_select);
                    } else {
                        TreePath _selected_path = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (_selected_path != null) {
                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent();
                            Object _imr_node = _node.getUserObject();
                            if (_imr_node instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.removeServer(((ServerInfo)_imr_node).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to remove!");
                        }
                    }
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_hold_mi || (JMenuItem)_source == ImRManagerGUI.this.m_hold_cmi) {
                    int _select = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (_select > -1) {
                        ImRManagerGUI.this.m_model.holdServer(_select);
                    } else {
                        TreePath _selected_path = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (_selected_path != null) {
                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent();
                            Object _imr_node = _node.getUserObject();
                            if (_imr_node instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.holdServer(((ServerInfo)_imr_node).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to hold!");
                        }
                    }
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_refresh_mi || (JMenuItem)_source == ImRManagerGUI.this.m_refresh_cmi) {
                    int _select = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (_select > -1) {
                        ImRManagerGUI.this.m_model.refreshServer(_select);
                    } else {
                        TreePath _selected_path = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (_selected_path != null) {
                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent();
                            Object _imr_node = _node.getUserObject();
                            if (_imr_node instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.refreshServer(((ServerInfo)_imr_node).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to refresh!");
                        }
                    }
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_release_mi || (JMenuItem)_source == ImRManagerGUI.this.m_release_cmi) {
                    int _select = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (_select > -1) {
                        ImRManagerGUI.this.m_model.releaseServer(_select);
                    } else {
                        TreePath _selected_path = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (_selected_path != null) {
                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent();
                            Object _imr_node = _node.getUserObject();
                            if (_imr_node instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.releaseServer(((ServerInfo)_imr_node).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to release!");
                        }
                    }
                } else if ((JMenuItem)_source == ImRManagerGUI.this.m_setdown_mi || (JMenuItem)_source == ImRManagerGUI.this.m_setdown_cmi) {
                    int _select = ImRManagerGUI.this.m_server_table.getSelectedRow();
                    if (_select > -1) {
                        ImRManagerGUI.this.m_model.setServerDown(_select);
                    } else {
                        TreePath _selected_path = ImRManagerGUI.this.m_tree.getSelectionPath();
                        if (_selected_path != null) {
                            DefaultMutableTreeNode _node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent();
                            Object _imr_node = _node.getUserObject();
                            if (_imr_node instanceof ServerInfo) {
                                ImRManagerGUI.this.m_model.setServerDown(((ServerInfo)_imr_node).name);
                            } else {
                                System.out.println("Please select a server node!");
                            }
                        } else {
                            System.out.println("Please select a server to set down!");
                        }
                    }
                }
            }
        }

        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode _select = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
            Object _node_obj = _select.getUserObject();
            if (_node_obj instanceof ServerInfo) {
                ImRManagerGUI.this.m_poa_table.clearSelection();
                ImRManagerGUI.this.m_server_table.clearSelection();
                ImRManagerGUI.this.showServerTable();
            } else if (_node_obj instanceof ImRInfo) {
                ImRManagerGUI.this.m_server_table.clearSelection();
                ImRManagerGUI.this.showServerTable();
            } else if (_node_obj instanceof POAInfo) {
                ImRManagerGUI.this.m_server_table.clearSelection();
                ServerInfo _parent = (ServerInfo)((DefaultMutableTreeNode)_select.getParent()).getUserObject();
                ImRManagerGUI.this.m_model.poaTableForServer(_parent);
                if (ImRManagerGUI.this.m_poa_table.getRowCount() > 1) {
                    int _row = ImRManagerGUI.this.m_model.getRow(_parent, (POAInfo)_node_obj);
                    ImRManagerGUI.this.m_poa_table.clearSelection();
                    ImRManagerGUI.this.m_poa_table.setRowSelectionInterval(_row, _row);
                }
                ImRManagerGUI.this.showPOATable();
            }
        }

        public void valueChanged(ListSelectionEvent event) {
            if (!((ListSelectionModel)event.getSource()).isSelectionEmpty()) {
                ImRManagerGUI.this.m_tree.clearSelection();
            }
        }

        public void mouseClicked(MouseEvent event) {
            this.maybeShowContextMenu(event);
        }

        public void mouseEntered(MouseEvent param1) {
        }

        public void mouseExited(MouseEvent param1) {
        }

        public void mousePressed(MouseEvent event) {
            this.maybeShowContextMenu(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.maybeShowContextMenu(event);
        }

        private void maybeShowContextMenu(MouseEvent event) {
            if (event.isPopupTrigger()) {
                DefaultMutableTreeNode _node;
                TreePath _selected_path;
                Component _source = event.getComponent();
                if (_source == ImRManagerGUI.this.m_server_table) {
                    if (ImRManagerGUI.this.m_server_table.getSelectedRow() > -1) {
                        ImRManagerGUI.this.m_context_menu.show(_source, event.getX(), event.getY());
                    }
                } else if (_source == ImRManagerGUI.this.m_tree && (_selected_path = ImRManagerGUI.this.m_tree.getSelectionPath()) != null && (_node = (DefaultMutableTreeNode)_selected_path.getLastPathComponent()).getUserObject() instanceof ServerInfo) {
                    ImRManagerGUI.this.m_context_menu.show(_source, event.getX(), event.getY());
                }
            }
        }
    }
}

