/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheHolder;
import org.infinispan.client.hotrod.RemoteCacheKey;
import org.infinispan.client.hotrod.SecurityActions;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.EagerNearRemoteCache;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class RemoteCacheManager
implements BasicCacheContainer {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String DEFAULT_CACHE_NAME = "___defaultcache";
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    private volatile boolean started = false;
    private final Map<RemoteCacheKey, RemoteCacheHolder> cacheName2RemoteCache = new HashMap<RemoteCacheKey, RemoteCacheHolder>();
    private final AtomicInteger defaultCacheTopologyId = new AtomicInteger(-1);
    private Configuration configuration;
    private Codec codec;
    private Marshaller marshaller;
    protected TransportFactory transportFactory;
    private ExecutorService asyncExecutorService;
    protected ClientListenerNotifier listenerNotifier;

    public RemoteCacheManager(Configuration configuration) {
        this(configuration, true);
    }

    public RemoteCacheManager(Configuration configuration, boolean start) {
        this.configuration = configuration;
        if (start) {
            this.start();
        }
    }

    @Deprecated
    public RemoteCacheManager(Marshaller marshaller, Properties props, boolean start) {
        this(new ConfigurationBuilder().classLoader(Thread.currentThread().getContextClassLoader()).withProperties(props).marshaller(marshaller.getClass()).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(Marshaller marshaller, Properties props, boolean start, ClassLoader classLoader, ExecutorFactory asyncExecutorFactory) {
        this(new ConfigurationBuilder().classLoader(classLoader).withProperties(props).marshaller(marshaller).asyncExecutorFactory().factory(asyncExecutorFactory).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(Marshaller marshaller, Properties props) {
        this(marshaller, props, true);
    }

    @Deprecated
    public RemoteCacheManager(Marshaller marshaller, Properties props, ExecutorFactory asyncExecutorFactory) {
        this(new ConfigurationBuilder().withProperties(props).marshaller(marshaller).asyncExecutorFactory().factory(asyncExecutorFactory).build());
    }

    @Deprecated
    public RemoteCacheManager(Marshaller marshaller, Properties props, ClassLoader classLoader) {
        this(new ConfigurationBuilder().classLoader(classLoader).marshaller(marshaller).withProperties(props).build());
    }

    @Deprecated
    public RemoteCacheManager(Properties props, boolean start) {
        this(new ConfigurationBuilder().withProperties(props).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(Properties props, boolean start, ClassLoader classLoader, ExecutorFactory asyncExecutorFactory) {
        this(new ConfigurationBuilder().classLoader(classLoader).asyncExecutorFactory().factory(asyncExecutorFactory).withProperties(props).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(Properties props) {
        this(new ConfigurationBuilder().withProperties(props).build());
    }

    @Deprecated
    public RemoteCacheManager(Properties props, ClassLoader classLoader) {
        this(new ConfigurationBuilder().classLoader(classLoader).withProperties(props).build());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public Properties getProperties() {
        Properties properties = new Properties();
        if (this.configuration.asyncExecutorFactory().factoryClass() != null) {
            properties.setProperty("infinispan.client.hotrod.async_executor_factory", this.configuration.asyncExecutorFactory().factoryClass().getName());
            TypedProperties aefProps = this.configuration.asyncExecutorFactory().properties();
            for (String key : Arrays.asList("infinispan.client.hotrod.default_executor_factory.pool_size", "infinispan.client.hotrod.default_executor_factory.queue_size")) {
                if (!aefProps.containsKey((Object)key)) continue;
                properties.setProperty(key, aefProps.getProperty(key));
            }
        }
        properties.setProperty("infinispan.client.hotrod.request_balancing_strategy", this.configuration.balancingStrategy().getName());
        properties.setProperty("infinispan.client.hotrod.connect_timeout", Integer.toString(this.configuration.connectionTimeout()));
        for (int i = 1; i <= this.configuration.consistentHashImpl().length; ++i) {
            properties.setProperty("infinispan.client.hotrod.hash_function_impl." + i, this.configuration.consistentHashImpl()[i - 1].getName());
        }
        properties.setProperty("infinispan.client.hotrod.force_return_values", Boolean.toString(this.configuration.forceReturnValues()));
        properties.setProperty("infinispan.client.hotrod.key_size_estimate", Integer.toString(this.configuration.keySizeEstimate()));
        properties.setProperty("infinispan.client.hotrod.marshaller", this.configuration.marshallerClass().getName());
        properties.setProperty("infinispan.client.hotrod.ping_on_startup", Boolean.toString(this.configuration.pingOnStartup()));
        properties.setProperty("infinispan.client.hotrod.protocol_version", this.configuration.protocolVersion());
        properties.setProperty("infinispan.client.hotrod.socket_timeout", Integer.toString(this.configuration.socketTimeout()));
        properties.setProperty("infinispan.client.hotrod.tcp_no_delay", Boolean.toString(this.configuration.tcpNoDelay()));
        properties.setProperty("infinispan.client.hotrod.tcp_keep_alive", Boolean.toString(this.configuration.tcpKeepAlive()));
        properties.setProperty("infinispan.client.hotrod.transport_factory", this.configuration.transportFactory().getName());
        properties.setProperty("infinispan.client.hotrod.value_size_estimate", Integer.toString(this.configuration.valueSizeEstimate()));
        properties.setProperty("infinispan.client.hotrod.max_retries", Integer.toString(this.configuration.maxRetries()));
        properties.setProperty("exhaustedAction", Integer.toString(this.configuration.connectionPool().exhaustedAction().ordinal()));
        properties.setProperty("maxActive", Integer.toString(this.configuration.connectionPool().maxActive()));
        properties.setProperty("maxTotal", Integer.toString(this.configuration.connectionPool().maxTotal()));
        properties.setProperty("maxWait", Long.toString(this.configuration.connectionPool().maxWait()));
        properties.setProperty("maxIdle", Integer.toString(this.configuration.connectionPool().maxIdle()));
        properties.setProperty("minIdle", Integer.toString(this.configuration.connectionPool().minIdle()));
        properties.setProperty("numTestsPerEvictionRun", Integer.toString(this.configuration.connectionPool().numTestsPerEvictionRun()));
        properties.setProperty("minEvictableIdleTimeMillis", Long.toString(this.configuration.connectionPool().minEvictableIdleTime()));
        properties.setProperty("timeBetweenEvictionRunsMillis", Long.toString(this.configuration.connectionPool().timeBetweenEvictionRuns()));
        properties.setProperty("lifo", Boolean.toString(this.configuration.connectionPool().lifo()));
        properties.setProperty("testOnBorrow", Boolean.toString(this.configuration.connectionPool().testOnBorrow()));
        properties.setProperty("testOnReturn", Boolean.toString(this.configuration.connectionPool().testOnReturn()));
        properties.setProperty("testWhileIdle", Boolean.toString(this.configuration.connectionPool().testWhileIdle()));
        StringBuilder servers = new StringBuilder();
        for (ServerConfiguration server : this.configuration.servers()) {
            if (servers.length() > 0) {
                servers.append(";");
            }
            servers.append(server.host()).append(":").append(server.port());
        }
        properties.setProperty("infinispan.client.hotrod.server_list", servers.toString());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        builder.classLoader(cl);
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, cl);
        if (stream == null) {
            log.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
        } else {
            try {
                builder.withProperties(this.loadFromStream(stream));
            }
            finally {
                Util.close((Closeable)stream);
            }
        }
        this.configuration = builder.build();
        if (start) {
            this.start();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    @Deprecated
    public RemoteCacheManager(String host, int port, boolean start) {
        this(host, port, start, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(String host, int port, boolean start, ClassLoader classLoader) {
        this(new ConfigurationBuilder().classLoader(classLoader).addServer().host(host).port(port).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(String host, int port) {
        this(host, port, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(String host, int port, ClassLoader classLoader) {
        this(host, port, true, classLoader);
    }

    @Deprecated
    public RemoteCacheManager(String servers, boolean start) {
        this(servers, start, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(String servers, boolean start, ClassLoader classLoader) {
        this(new ConfigurationBuilder().classLoader(classLoader).addServers(servers).build(), start);
    }

    @Deprecated
    public RemoteCacheManager(String servers) {
        this(servers, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(String servers, ClassLoader classLoader) {
        this(servers, true, classLoader);
    }

    @Deprecated
    public RemoteCacheManager(URL config, boolean start) {
        this(config, start, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(URL config, boolean start, ClassLoader classLoader) {
        InputStream stream = null;
        try {
            stream = config.openStream();
            Properties properties = this.loadFromStream(stream);
            this.configuration = new ConfigurationBuilder().classLoader(classLoader).withProperties(properties).build();
        }
        catch (IOException e) {
            throw new HotRodClientException("Could not read URL:" + config, e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        if (start) {
            this.start();
        }
    }

    @Deprecated
    public RemoteCacheManager(URL config) {
        this(config, Thread.currentThread().getContextClassLoader());
    }

    @Deprecated
    public RemoteCacheManager(URL config, ClassLoader classLoader) {
        this(config, true, classLoader);
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.configuration.forceReturnValues());
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue) {
        return this.createRemoteCache(cacheName, forceReturnValue);
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.configuration.forceReturnValues());
    }

    public <K, V> RemoteCache<K, V> getCache(boolean forceReturnValue) {
        return this.createRemoteCache("", forceReturnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SecurityActions.setProperty("sun.nio.ch.bugLevel", "\"\"");
        this.codec = CodecFactory.getCodec(this.configuration.protocolVersion());
        this.transportFactory = (TransportFactory)Util.getInstance(this.configuration.transportFactory());
        if (this.marshaller == null) {
            this.marshaller = this.configuration.marshaller();
            if (this.marshaller == null) {
                this.marshaller = (Marshaller)Util.getInstance(this.configuration.marshallerClass());
            }
        }
        if (this.asyncExecutorService == null) {
            ExecutorFactory executorFactory = this.configuration.asyncExecutorFactory().factory();
            if (executorFactory == null) {
                executorFactory = (ExecutorFactory)Util.getInstance(this.configuration.asyncExecutorFactory().factoryClass());
            }
            this.asyncExecutorService = executorFactory.getExecutor((Properties)this.configuration.asyncExecutorFactory().properties());
        }
        this.listenerNotifier = ClientListenerNotifier.create(this.codec, this.marshaller);
        this.transportFactory.start(this.codec, this.configuration, this.defaultCacheTopologyId, this.listenerNotifier);
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            for (RemoteCacheHolder rcc : this.cacheName2RemoteCache.values()) {
                this.startRemoteCache(rcc, this.defaultCacheTopologyId);
            }
        }
        log.version(RemoteCacheManager.class.getPackage().getImplementationVersion());
        this.started = true;
    }

    public void stop() {
        if (this.isStarted()) {
            this.listenerNotifier.stop();
            this.transportFactory.destroy();
            this.asyncExecutorService.shutdownNow();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, Boolean forceReturnValueOverride) {
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValueOverride);
            if (!this.cacheName2RemoteCache.containsKey(key)) {
                RemoteCacheImpl<K, V> result = this.createRemoteCache(cacheName);
                RemoteCacheHolder rcc = new RemoteCacheHolder(result, forceReturnValueOverride == null ? this.configuration.forceReturnValues() : forceReturnValueOverride.booleanValue());
                AtomicInteger topologyId = cacheName.isEmpty() ? this.defaultCacheTopologyId : new AtomicInteger(-1);
                this.startRemoteCache(rcc, topologyId);
                if (this.configuration.pingOnStartup() && !cacheName.equals(DEFAULT_CACHE_NAME) && this.ping(result) == PingOperation.PingResult.CACHE_DOES_NOT_EXIST) {
                    return null;
                }
                result.start();
                this.cacheName2RemoteCache.put(key, rcc);
                return result;
            }
            return this.cacheName2RemoteCache.get((Object)key).remoteCache;
        }
    }

    private <K, V> RemoteCacheImpl<K, V> createRemoteCache(String cacheName) {
        switch (this.configuration.nearCache().mode()) {
            case LAZY: {
                NearCacheService<K, V> invalidateNearCache = this.createNearCacheService(this.configuration.nearCache());
                return new InvalidatedNearRemoteCache<K, V>(this, cacheName, invalidateNearCache);
            }
            case EAGER: {
                NearCacheService<K, V> eagerNearCache = this.createNearCacheService(this.configuration.nearCache());
                return new EagerNearRemoteCache<K, V>(this, cacheName, eagerNearCache);
            }
        }
        return new RemoteCacheImpl(this, cacheName);
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    private <K, V> PingOperation.PingResult ping(RemoteCacheImpl<K, V> cache) {
        if (this.transportFactory == null) {
            return PingOperation.PingResult.FAIL;
        }
        return cache.ping();
    }

    private void startRemoteCache(RemoteCacheHolder remoteCacheHolder, AtomicInteger topologyId) {
        RemoteCacheImpl<?, ?> remoteCache = remoteCacheHolder.remoteCache;
        OperationsFactory operationsFactory = new OperationsFactory(this.transportFactory, remoteCache.getName(), topologyId, remoteCacheHolder.forceReturnValue, this.codec, this.listenerNotifier);
        remoteCache.init(this.marshaller, this.asyncExecutorService, operationsFactory, this.configuration.keySizeEstimate(), this.configuration.valueSizeEstimate());
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.equals(DEFAULT_CACHE_NAME) ? HotRodConstants.DEFAULT_CACHE_NAME_BYTES : cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }
}

