/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.net.InetSocketAddress;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.NettyRestServer;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.subsystem.SecurityMode;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class RestService
implements Service<Lifecycle> {
    private static final String HOME_DIR = "jboss.home.dir";
    private static final String DEFAULT_CONTEXT_PATH = "";
    private final InjectedValue<PathManager> pathManagerInjector = new InjectedValue();
    private final InjectedValue<EmbeddedCacheManager> cacheManagerInjector = new InjectedValue();
    private final InjectedValue<SecurityDomainContext> securityDomainContextInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
    private final ModelNode config;
    private final String path;
    private final String securityDomain;
    private final String authMethod;
    private final SecurityMode securityMode;
    private PathManager.Callback.Handle callbackHandle;
    private final RestServerConfigurationBuilder configurationBuilder;
    private Lifecycle restServer;

    public RestService(ModelNode config) {
        this.config = config.clone();
        this.path = this.config.hasDefined("context-path") ? RestService.cleanContextPath(this.config.get("context-path").asString()) : DEFAULT_CONTEXT_PATH;
        this.securityDomain = config.hasDefined("security-domain") ? config.get("security-domain").asString() : null;
        this.authMethod = config.hasDefined("auth-method") ? config.get("auth-method").asString() : "BASIC";
        this.securityMode = config.hasDefined("security-mode") ? SecurityMode.valueOf(config.get("security-mode").asString()) : SecurityMode.READ_WRITE;
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.extendedHeaders(config.hasDefined("extended-headers") ? ExtendedHeaders.valueOf((String)config.get("extended-headers").asString()) : ExtendedHeaders.ON_DEMAND);
        this.configurationBuilder = builder;
    }

    private static String cleanContextPath(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public synchronized void start(StartContext startContext) throws StartException {
        EndpointLogger.ROOT_LOGGER.endpointStarting("REST");
        try {
            SocketBinding socketBinding = (SocketBinding)this.getSocketBinding().getValue();
            InetSocketAddress socketAddress = socketBinding.getSocketAddress();
            this.configurationBuilder.host(socketAddress.getAddress().getHostAddress());
            this.configurationBuilder.port(socketAddress.getPort());
            this.restServer = NettyRestServer.apply((RestServerConfiguration)this.configurationBuilder.build(), (EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagerInjector.getValue()));
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextCreationFailed(e);
        }
        try {
            this.restServer.start();
            EndpointLogger.ROOT_LOGGER.httpEndpointStarted("REST", this.path, "rest");
        }
        catch (Exception e) {
            throw EndpointLogger.ROOT_LOGGER.restContextStartFailed(e);
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public synchronized void stop(StopContext stopContext) {
        this.restServer.stop();
    }

    String getCacheContainerName() {
        if (!this.config.hasDefined("cache-container")) {
            return null;
        }
        return this.config.get("cache-container").asString();
    }

    public synchronized Lifecycle getValue() throws IllegalStateException {
        if (this.restServer == null) {
            throw new IllegalStateException();
        }
        return this.restServer;
    }

    public InjectedValue<PathManager> getPathManagerInjector() {
        return this.pathManagerInjector;
    }

    public InjectedValue<EmbeddedCacheManager> getCacheManager() {
        return this.cacheManagerInjector;
    }

    public InjectedValue<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextInjector;
    }

    InjectedValue<SocketBinding> getSocketBinding() {
        return this.socketBinding;
    }
}

