/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.ejb.BatchContext;
import org.wildfly.clustering.ejb.Batcher;
import org.wildfly.clustering.ejb.infinispan.TransactionBatch;

public class InfinispanBatcher
implements Batcher<TransactionBatch> {
    private final TransactionManager tm;

    public InfinispanBatcher(Cache<?, ?> cache) {
        this(cache.getAdvancedCache().getTransactionManager());
    }

    public InfinispanBatcher(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionBatch startBatch() {
        try {
            Transaction tx = this.tm.getTransaction();
            return tx == null ? new NewTransactionBatch(this.tm) : new ExistingTransactionBatch(tx);
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public BatchContext resume(TransactionBatch batch) {
        try {
            Transaction tx = batch.getTransaction();
            return new InfinispanBatchContext(this.tm, tx);
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new CacheException(e);
        }
    }

    private static class NewTransactionBatch
    extends ExistingTransactionBatch {
        private final TransactionManager tm;

        NewTransactionBatch(TransactionManager tm) throws SystemException {
            this(tm, NewTransactionBatch.begin(tm));
        }

        private static Transaction begin(TransactionManager tm) throws SystemException {
            try {
                tm.begin();
                return tm.getTransaction();
            }
            catch (NotSupportedException e) {
                throw new CacheException((Throwable)e);
            }
        }

        private NewTransactionBatch(TransactionManager tm, Transaction tx) {
            super(tx);
            this.tm = tm;
        }

        @Override
        public void close() {
            try {
                this.tm.commit();
            }
            catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                throw new CacheException(e);
            }
        }

        @Override
        public void discard() {
            try {
                this.tm.rollback();
            }
            catch (SystemException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    private static class ExistingTransactionBatch
    implements TransactionBatch {
        private final Transaction tx;

        ExistingTransactionBatch(Transaction tx) {
            this.tx = tx;
        }

        @Override
        public Transaction getTransaction() {
            return this.tx;
        }

        public void close() {
        }

        public void discard() {
        }
    }

    private static class InfinispanBatchContext
    implements BatchContext {
        private final TransactionManager tm;
        private final Transaction existingTx;
        private final Transaction tx;

        InfinispanBatchContext(TransactionManager tm, Transaction tx) throws SystemException, InvalidTransactionException {
            this.tm = tm;
            this.tx = tx;
            this.existingTx = this.tm.suspend();
            this.tm.resume(this.tx);
        }

        public void close() {
            if (this.existingTx != null && !this.existingTx.equals(this.tx)) {
                try {
                    this.tm.resume(this.existingTx);
                }
                catch (InvalidTransactionException | SystemException e) {
                    throw new CacheException(e);
                }
            }
        }
    }
}

