/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public class EJBValidationConfigurator
implements ComponentConfigurator {
    public static final EJBValidationConfigurator INSTANCE = new EJBValidationConfigurator();

    private EJBValidationConfigurator() {
    }

    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)context.getDeploymentUnit().getAttachment(Attachments.REFLECTION_INDEX);
        ClassReflectionIndex classIndex = deploymentReflectionIndex.getClassIndex(configuration.getComponentClass());
        Constructor ctor = classIndex.getConstructor(new String[0]);
        boolean noInterface = false;
        for (ViewDescription view : description.getViews()) {
            if (!view.getViewClassName().equals(description.getComponentClassName())) continue;
            noInterface = true;
        }
        if (ctor == null && noInterface) {
            throw EjbMessages.MESSAGES.ejbMustHavePublicDefaultConstructor(description.getComponentName(), description.getComponentClassName());
        }
        if (configuration.getComponentClass().getEnclosingClass() != null) {
            throw EjbMessages.MESSAGES.ejbMustNotBeInnerClass(description.getComponentName(), description.getComponentClassName());
        }
        if (!Modifier.isPublic(configuration.getComponentClass().getModifiers())) {
            throw EjbMessages.MESSAGES.ejbMustBePublicClass(description.getComponentName(), description.getComponentClassName());
        }
        if (Modifier.isFinal(configuration.getComponentClass().getModifiers())) {
            throw EjbMessages.MESSAGES.ejbMustNotBeFinalClass(description.getComponentName(), description.getComponentClassName());
        }
    }
}

