/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerServiceImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.OutputStreamByteOutput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.util.Base64;

public class DatabaseTimerPersistence
implements TimerPersistence,
Service<DatabaseTimerPersistence> {
    private final InjectedValue<ManagedReferenceFactory> dataSourceInjectedValue = new InjectedValue();
    private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();
    private final String name;
    private final String database;
    private final String partition;
    private volatile ManagedReference managedReference;
    private volatile DataSource dataSource;
    private volatile Properties sql;
    private MarshallerFactory factory;
    private MarshallingConfiguration configuration;
    private static final String CREATE_TABLE = "create-table";
    private static final String CREATE_TIMER = "create-timer";
    private static final String UPDATE_TIMER = "update-timer";
    private static final String LOAD_ALL_TIMERS = "load-all-timers";
    private static final String LOAD_TIMER = "load-timer";
    private static final String DELETE_TIMER = "delete-timer";

    public DatabaseTimerPersistence(String name, String database, String partition) {
        this.name = name;
        this.database = database;
        this.partition = partition;
    }

    public void start(StartContext context) throws StartException {
        this.factory = new RiverMarshallerFactory();
        this.configuration = new MarshallingConfiguration();
        this.configuration.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)((ModuleLoader)this.moduleLoader.getValue())));
        this.managedReference = ((ManagedReferenceFactory)this.dataSourceInjectedValue.getValue()).getReference();
        this.dataSource = (DataSource)this.managedReference.getInstance();
        InputStream stream = DatabaseTimerPersistence.class.getClassLoader().getResourceAsStream("timer-sql.properties");
        this.sql = new Properties();
        try {
            this.sql.load(stream);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        finally {
            DatabaseTimerPersistence.safeClose(stream);
        }
        this.runCreateTable();
    }

    public void stop(StopContext context) {
        this.managedReference.release();
        this.managedReference = null;
        this.dataSource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runCreateTable() {
        String loadTimer = this.sql(LOAD_TIMER);
        Connection connection = null;
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(loadTimer);
            preparedStatement.setString(1, "NON-EXISTENT");
            preparedStatement.setString(2, "NON-EXISTENT");
            preparedStatement.setString(3, "NON-EXISTENT");
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            block11: {
                try {
                    if (connection != null) {
                        try {
                            String[] statements;
                            String createTable = this.sql(CREATE_TABLE);
                            for (String sql : statements = createTable.split(";")) {
                                try {
                                    statement = connection.createStatement();
                                    statement.executeUpdate(sql);
                                }
                                finally {
                                    DatabaseTimerPersistence.safeClose(statement);
                                }
                            }
                            break block11;
                        }
                        catch (SQLException e1) {
                            EjbLogger.EJB3_LOGGER.couldNotCreateTable(e1);
                            break block11;
                        }
                    }
                    EjbLogger.EJB3_LOGGER.couldNotCreateTable(e);
                }
                catch (Throwable throwable) {
                    DatabaseTimerPersistence.safeClose(resultSet);
                    DatabaseTimerPersistence.safeClose(preparedStatement);
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                    throw throwable;
                }
            }
            DatabaseTimerPersistence.safeClose(resultSet);
            DatabaseTimerPersistence.safeClose(preparedStatement);
            DatabaseTimerPersistence.safeClose(statement);
            DatabaseTimerPersistence.safeClose(connection);
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(preparedStatement);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    private String sql(String key) {
        String result;
        if (this.database != null && (result = this.sql.getProperty(key + "." + this.database)) != null) {
            return result;
        }
        return this.sql.getProperty(key);
    }

    @Override
    public void addTimer(TimerImpl timerEntity) {
        String createTimer = this.sql(CREATE_TIMER);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(createTimer);
            this.statementParameters(timerEntity, statement);
            statement.execute();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseTimerPersistence.safeClose(resultSet);
                DatabaseTimerPersistence.safeClose(statement);
                DatabaseTimerPersistence.safeClose(connection);
                throw throwable;
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    @Override
    public void persistTimer(TimerImpl timerEntity) {
        ResultSet resultSet;
        PreparedStatement statement;
        Connection connection;
        block5: {
            connection = null;
            statement = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                if (timerEntity.getState() == TimerState.CANCELED || timerEntity.getState() == TimerState.EXPIRED) {
                    String deleteTimer = this.sql(DELETE_TIMER);
                    statement = connection.prepareStatement(deleteTimer);
                    statement.setString(1, timerEntity.getTimedObjectId());
                    statement.setString(2, timerEntity.getId());
                    statement.setString(3, this.partition);
                    statement.execute();
                    break block5;
                }
                String updateTimer = this.sql(UPDATE_TIMER);
                statement = connection.prepareStatement(updateTimer);
                statement.setTimestamp(1, this.timestamp(timerEntity.getNextExpiration()));
                statement.setTimestamp(2, this.timestamp(timerEntity.getPreviousRun()));
                statement.setString(3, timerEntity.getState().name());
                statement.setString(4, timerEntity.getTimedObjectId());
                statement.setString(5, timerEntity.getId());
                statement.setString(6, this.partition);
                statement.execute();
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DatabaseTimerPersistence.safeClose(resultSet);
                    DatabaseTimerPersistence.safeClose(statement);
                    DatabaseTimerPersistence.safeClose(connection);
                    throw throwable;
                }
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
    }

    @Override
    public void timerUndeployed(String timedObjectId) {
    }

    @Override
    public List<TimerImpl> loadActiveTimers(String timedObjectId, TimerServiceImpl timerService) {
        ArrayList<TimerImpl> arrayList;
        String loadTimer = this.sql(LOAD_ALL_TIMERS);
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement(loadTimer);
            statement.setString(1, timedObjectId);
            statement.setString(2, this.partition);
            resultSet = statement.executeQuery();
            ArrayList<TimerImpl> timers = new ArrayList<TimerImpl>();
            while (resultSet.next()) {
                try {
                    TimerImpl timerImpl = this.timerFromResult(resultSet, timerService);
                    if (timerImpl == null) continue;
                    timers.add(timerImpl);
                }
                catch (Exception e) {
                    EjbLogger.ROOT_LOGGER.timerReinstatementFailed(resultSet.getString(2), resultSet.getString(1), e);
                }
            }
            arrayList = timers;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseTimerPersistence.safeClose(resultSet);
                DatabaseTimerPersistence.safeClose(statement);
                DatabaseTimerPersistence.safeClose(connection);
                throw throwable;
            }
        }
        DatabaseTimerPersistence.safeClose(resultSet);
        DatabaseTimerPersistence.safeClose(statement);
        DatabaseTimerPersistence.safeClose(connection);
        return arrayList;
    }

    public DatabaseTimerPersistence getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private TimerImpl timerFromResult(ResultSet resultSet, TimerServiceImpl timerService) throws SQLException {
        boolean calendarTimer = resultSet.getBoolean(24);
        TimerImpl.Builder builder = null;
        if (calendarTimer) {
            CalendarTimer.Builder cb = CalendarTimer.builder();
            builder = cb;
            cb.setScheduleExprSecond(resultSet.getString(10));
            cb.setScheduleExprMinute(resultSet.getString(11));
            cb.setScheduleExprHour(resultSet.getString(12));
            cb.setScheduleExprDayOfWeek(resultSet.getString(13));
            cb.setScheduleExprDayOfMonth(resultSet.getString(14));
            cb.setScheduleExprMonth(resultSet.getString(15));
            cb.setScheduleExprYear(resultSet.getString(16));
            cb.setScheduleExprStartDate(resultSet.getTimestamp(17));
            cb.setScheduleExprEndDate(resultSet.getTimestamp(18));
            cb.setScheduleExprTimezone(resultSet.getString(19));
            cb.setAutoTimer(resultSet.getBoolean(20));
            String clazz = resultSet.getString(21);
            String methodName = resultSet.getString(22);
            if (methodName != null) {
                String paramString = resultSet.getString(23);
                String[] params = paramString == null || paramString.isEmpty() ? new String[]{} : paramString.split(";");
                Method timeoutMethod = CalendarTimer.getTimeoutMethod(new TimeoutMethod(clazz, methodName, params), (TimedObjectInvoker)timerService.getTimedObjectInvoker().getValue());
                if (timeoutMethod == null) {
                    EjbLogger.ROOT_LOGGER.timerReinstatementFailed(resultSet.getString(2), resultSet.getString(1), new NoSuchMethodException());
                }
                cb.setTimeoutMethod(timeoutMethod);
            }
        } else {
            builder = TimerImpl.builder();
        }
        builder.setId(resultSet.getString(1));
        builder.setTimedObjectId(resultSet.getString(2));
        builder.setInitialDate(resultSet.getTimestamp(3));
        builder.setRepeatInterval(resultSet.getLong(4));
        builder.setNextDate(resultSet.getTimestamp(5));
        builder.setPreviousRun(resultSet.getTimestamp(6));
        builder.setPrimaryKey(this.deSerialize(resultSet.getString(7)));
        builder.setInfo((Serializable)this.deSerialize(resultSet.getString(8)));
        builder.setTimerState(TimerState.valueOf(resultSet.getString(9)));
        builder.setPersistent(true);
        return builder.build(timerService);
    }

    private void statementParameters(TimerImpl timerEntity, PreparedStatement statement) throws SQLException {
        statement.setString(1, timerEntity.getId());
        statement.setString(2, timerEntity.getTimedObjectId());
        statement.setTimestamp(3, this.timestamp(timerEntity.getInitialExpiration()));
        statement.setLong(4, timerEntity.getInterval());
        statement.setTimestamp(5, this.timestamp(timerEntity.getNextExpiration()));
        statement.setTimestamp(6, this.timestamp(timerEntity.getPreviousRun()));
        statement.setString(7, this.serialize((Serializable)timerEntity.getPrimaryKey()));
        statement.setString(8, this.serialize(timerEntity.getTimerInfo()));
        statement.setString(9, timerEntity.getState().name());
        if (timerEntity instanceof CalendarTimer) {
            CalendarTimer c = (CalendarTimer)timerEntity;
            statement.setString(10, c.getScheduleExpression().getSecond());
            statement.setString(11, c.getScheduleExpression().getMinute());
            statement.setString(12, c.getScheduleExpression().getHour());
            statement.setString(13, c.getScheduleExpression().getDayOfWeek());
            statement.setString(14, c.getScheduleExpression().getDayOfMonth());
            statement.setString(15, c.getScheduleExpression().getMonth());
            statement.setString(16, c.getScheduleExpression().getYear());
            statement.setTimestamp(17, this.timestamp(c.getScheduleExpression().getStart()));
            statement.setTimestamp(18, this.timestamp(c.getScheduleExpression().getEnd()));
            statement.setString(19, c.getScheduleExpression().getTimezone());
            statement.setBoolean(20, c.isAutoTimer());
            if (c.isAutoTimer()) {
                statement.setString(21, c.getTimeoutMethod().getDeclaringClass().getName());
                statement.setString(22, c.getTimeoutMethod().getName());
                StringBuilder params = new StringBuilder();
                Class<?>[] parameterTypes = c.getTimeoutMethod().getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    params.append(parameterTypes[i].getName());
                    if (i == parameterTypes.length - 1) continue;
                    params.append(";");
                }
                statement.setString(23, params.toString());
            } else {
                statement.setString(21, null);
                statement.setString(22, null);
                statement.setString(23, null);
            }
            statement.setBoolean(24, true);
        } else {
            statement.setString(10, null);
            statement.setString(11, null);
            statement.setString(12, null);
            statement.setString(13, null);
            statement.setString(14, null);
            statement.setString(15, null);
            statement.setString(16, null);
            statement.setTimestamp(17, null);
            statement.setTimestamp(18, null);
            statement.setString(19, null);
            statement.setBoolean(20, false);
            statement.setString(21, null);
            statement.setString(22, null);
            statement.setString(23, null);
            statement.setBoolean(24, false);
        }
        statement.setString(25, this.partition);
    }

    private String serialize(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Marshaller marshaller = this.factory.createMarshaller(this.configuration);
            marshaller.start((ByteOutput)new OutputStreamByteOutput((OutputStream)out));
            marshaller.writeObject((Object)serializable);
            marshaller.finish();
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Base64.encodeBytes((byte[])out.toByteArray());
    }

    public Object deSerialize(String data) throws SQLException {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(Base64.decode((String)data));
        try {
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
            unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)in));
            Object ret = unmarshaller.readObject();
            unmarshaller.finish();
            Object object = ret;
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            DatabaseTimerPersistence.safeClose(in);
        }
    }

    private Timestamp timestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public InjectedValue<ManagedReferenceFactory> getDataSourceInjectedValue() {
        return this.dataSourceInjectedValue;
    }

    public InjectedValue<ModuleLoader> getModuleLoader() {
        return this.moduleLoader;
    }

    private static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(Statement resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(Connection resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }

    private static void safeClose(ResultSet resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            EjbLogger.EJB3_LOGGER.tracef(t, "Closing resource failed", new Object[0]);
        }
    }
}

