/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Map;
import org.infinispan.cli.interpreter.Interpreter;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.SecurityActions;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CliInterpreterHandler
implements OperationStepHandler {
    public static final CliInterpreterHandler INSTANCE = new CliInterpreterHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode result = new ModelNode();
        try {
            String command = operation.require("command").asString();
            String cacheName = operation.has("cacheName") ? operation.get("cacheName").asString() : null;
            String sessionId = operation.has("sessionId") ? operation.get("sessionId").asString() : null;
            Interpreter interpreter = this.getInterpreter(context, operation);
            if (interpreter == null) {
                context.getFailureDescription().set("Interpreter not found!");
                context.getResult().set(result);
                return;
            }
            if (sessionId == null) {
                sessionId = interpreter.createSessionId(cacheName);
                CliInterpreterHandler.setInModelNode(result, "sessionId", sessionId);
            }
            Map<String, String> response = SecurityActions.executeInterpreter(interpreter, sessionId, command);
            this.setResponse(result, response);
            context.getResult().set(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getFailureDescription().set(e.getLocalizedMessage());
            context.getResult().set(result);
        }
        finally {
            context.stepCompleted();
        }
    }

    private void setResponse(ModelNode node, Map<String, String> response) {
        CliInterpreterHandler.setInModelNode(node, "cacheName", response.get(ResultKeys.CACHE.toString()));
        CliInterpreterHandler.setInModelNode(node, "result", response.get(ResultKeys.OUTPUT.toString()));
        CliInterpreterHandler.setInModelNode(node, "result", response.get(ResultKeys.ERROR.toString()));
        CliInterpreterHandler.setInModelNode(node, "isError", Boolean.toString(response.get(ResultKeys.ERROR.toString()) != null));
    }

    private static void setInModelNode(ModelNode node, String key, String value) {
        if (value != null) {
            node.get(key).set(value);
        }
    }

    private Interpreter getInterpreter(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getLastElement().getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        if (cacheManager == null) {
            return null;
        }
        return (Interpreter)cacheManager.getGlobalComponentRegistry().getComponent(Interpreter.class);
    }
}

