/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.server.infinispan.SecurityActions;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

@Listener
public class EmbeddedCacheManagerService
implements Service<EmbeddedCacheManager> {
    private static final Logger log = Logger.getLogger((String)EmbeddedCacheManagerService.class.getPackage().getName());
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final Value<EmbeddedCacheManagerConfiguration> config;
    private volatile EmbeddedCacheManager container;

    public static ServiceName getServiceName(String name) {
        return name != null ? SERVICE_NAME.append(new String[]{name}) : SERVICE_NAME;
    }

    public EmbeddedCacheManagerService(Value<EmbeddedCacheManagerConfiguration> config) {
        this.config = config;
    }

    public EmbeddedCacheManager getValue() {
        return this.container;
    }

    public void start(StartContext context) {
        EmbeddedCacheManagerConfiguration config = (EmbeddedCacheManagerConfiguration)this.config.getValue();
        this.container = new DefaultEmbeddedCacheManager(config.getGlobalConfiguration(), config.getDefaultCache());
        SecurityActions.registerAndStartContainer(this.container, this);
        log.debugf("%s cache container started", (Object)config.getName());
    }

    public void stop(StopContext context) {
        if (this.container != null && SecurityActions.stopAndUnregisterContainer(this.container, this)) {
            log.debugf("%s cache container stopped", (Object)((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
        }
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), ((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), ((EmbeddedCacheManagerConfiguration)this.config.getValue()).getName());
    }
}

