/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.near.NearCacheService;

public class InvalidatedNearRemoteCache<K, V>
extends RemoteCacheImpl<K, V> {
    private final NearCacheService<K, V> nearcache;

    public InvalidatedNearRemoteCache(RemoteCacheManager rcm, String name, NearCacheService<K, V> nearcache) {
        super(rcm, name);
        this.nearcache = nearcache;
    }

    @Override
    public V get(Object key) {
        VersionedValue<V> versioned = this.getVersioned(key);
        return versioned != null ? (V)versioned.getValue() : null;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        VersionedValue<V> nearValue = this.nearcache.get(key);
        if (nearValue == null) {
            VersionedValue remoteValue = super.getVersioned(key);
            if (remoteValue != null) {
                this.nearcache.putIfAbsent(key, remoteValue);
            }
            return remoteValue;
        }
        return nearValue;
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        V ret = super.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        this.nearcache.remove(key);
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        super.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        for (K k : map.keySet()) {
            this.nearcache.remove(k);
        }
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        boolean hasForceReturnValue = this.operationsFactory.hasFlag(Flag.FORCE_RETURN_VALUE);
        V prev = super.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        this.invalidateNearCacheIfNeeded(hasForceReturnValue, key, prev);
        return prev;
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        boolean replaced = super.replaceWithVersion(key, newValue, version, lifespanSeconds, maxIdleTimeSeconds);
        if (replaced) {
            this.nearcache.remove(key);
        }
        return replaced;
    }

    @Override
    public V remove(Object key) {
        boolean hasForceReturnValue = this.operationsFactory.hasFlag(Flag.FORCE_RETURN_VALUE);
        Object prev = super.remove(key);
        this.invalidateNearCacheIfNeeded(hasForceReturnValue, key, prev);
        return prev;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        boolean removed = super.removeWithVersion(key, version);
        if (removed) {
            this.nearcache.remove(key);
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        this.nearcache.clear();
    }

    void invalidateNearCacheIfNeeded(boolean hasForceReturnValue, Object key, Object prev) {
        if (!hasForceReturnValue || prev != null) {
            this.nearcache.remove(key);
        }
    }

    @Override
    public void start() {
        this.nearcache.start(this);
    }

    @Override
    public void stop() {
        this.nearcache.stop(this);
    }
}

