/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.configuration.global.ExecutorFactoryConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.configuration.global.ScheduledExecutorFactoryConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownConfiguration;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalConfiguration {
    public static final short DEFAULT_MARSHALL_VERSION = Version.getVersionShort();
    private final GlobalJmxStatisticsConfiguration globalJmxStatistics;
    private final TransportConfiguration transport;
    private final GlobalSecurityConfiguration security;
    private final SerializationConfiguration serialization;
    private final ShutdownConfiguration shutdown;
    private final Map<Class<?>, ?> modules;
    private final SiteConfiguration site;
    private final WeakReference<ClassLoader> cl;
    private final ThreadPoolConfiguration evictionThreadPool;
    private final ThreadPoolConfiguration listenerThreadPool;
    private final ThreadPoolConfiguration replicationQueueThreadPool;
    private final ThreadPoolConfiguration persistenceThreadPool;
    private final ThreadPoolConfiguration stateTransferThreadPool;

    GlobalConfiguration(ThreadPoolConfiguration evictionThreadPool, ThreadPoolConfiguration listenerThreadPool, ThreadPoolConfiguration replicationQueueThreadPool, ThreadPoolConfiguration persistenceThreadPool, ThreadPoolConfiguration stateTransferThreadPool, GlobalJmxStatisticsConfiguration globalJmxStatistics, TransportConfiguration transport, GlobalSecurityConfiguration security, SerializationConfiguration serialization, ShutdownConfiguration shutdown, List<?> modules, SiteConfiguration site, ClassLoader cl) {
        this.evictionThreadPool = evictionThreadPool;
        this.listenerThreadPool = listenerThreadPool;
        this.replicationQueueThreadPool = replicationQueueThreadPool;
        this.persistenceThreadPool = persistenceThreadPool;
        this.stateTransferThreadPool = stateTransferThreadPool;
        this.globalJmxStatistics = globalJmxStatistics;
        this.transport = transport;
        this.security = security;
        this.serialization = serialization;
        this.shutdown = shutdown;
        HashMap moduleMap = new HashMap();
        for (Object module : modules) {
            moduleMap.put(module.getClass(), module);
        }
        this.modules = Collections.unmodifiableMap(moduleMap);
        this.site = site;
        this.cl = new WeakReference<ClassLoader>(cl);
    }

    @Deprecated
    public ExecutorFactoryConfiguration asyncListenerExecutor() {
        return null;
    }

    @Deprecated
    public ExecutorFactoryConfiguration persistenceExecutor() {
        return null;
    }

    @Deprecated
    public ExecutorFactoryConfiguration asyncTransportExecutor() {
        return null;
    }

    @Deprecated
    public ExecutorFactoryConfiguration remoteCommandsExecutor() {
        return null;
    }

    @Deprecated
    public ScheduledExecutorFactoryConfiguration evictionScheduledExecutor() {
        return null;
    }

    @Deprecated
    public ScheduledExecutorFactoryConfiguration replicationQueueScheduledExecutor() {
        return null;
    }

    public ThreadPoolConfiguration evictionThreadPool() {
        return this.evictionThreadPool;
    }

    public ThreadPoolConfiguration listenerThreadPool() {
        return this.listenerThreadPool;
    }

    public ThreadPoolConfiguration replicationQueueThreadPool() {
        return this.replicationQueueThreadPool;
    }

    public ThreadPoolConfiguration persistenceThreadPool() {
        return this.persistenceThreadPool;
    }

    public ThreadPoolConfiguration stateTransferThreadPool() {
        return this.stateTransferThreadPool;
    }

    public GlobalJmxStatisticsConfiguration globalJmxStatistics() {
        return this.globalJmxStatistics;
    }

    public TransportConfiguration transport() {
        return this.transport;
    }

    public GlobalSecurityConfiguration security() {
        return this.security;
    }

    public SerializationConfiguration serialization() {
        return this.serialization;
    }

    public ShutdownConfiguration shutdown() {
        return this.shutdown;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.modules.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.modules;
    }

    public ClassLoader classLoader() {
        return (ClassLoader)this.cl.get();
    }

    public SiteConfiguration sites() {
        return this.site;
    }

    public String toString() {
        return "GlobalConfiguration{listenerThreadPool=" + this.listenerThreadPool + ", evictionThreadPool=" + this.evictionThreadPool + ", persistenceThreadPool=" + this.persistenceThreadPool + ", stateTransferThreadPool=" + this.stateTransferThreadPool + ", replicationQueueThreadPool=" + this.replicationQueueThreadPool + ", globalJmxStatistics=" + this.globalJmxStatistics + ", transport=" + this.transport + ", security=" + this.security + ", serialization=" + this.serialization + ", shutdown=" + this.shutdown + ", modules=" + this.modules + ", site=" + this.site + ", cl=" + this.cl + '}';
    }

    @Deprecated
    public ExecutorFactoryConfiguration totalOrderExecutor() {
        return null;
    }

    public boolean isClustered() {
        return this.transport().transport() != null;
    }
}

