/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.HashMap;
import java.util.Map;

public enum ORBInitializer {
    UNKNOWN("", ""),
    SECURITY_CLIENT("security", "org.jboss.as.jacorb.csiv2.CSIv2Initializer", "org.jboss.as.jacorb.csiv2.SASClientInitializer"),
    SECURITY_IDENTITY("security", "org.jboss.as.jacorb.csiv2.CSIv2Initializer", "org.jboss.as.jacorb.csiv2.SASInitializer"),
    TRANSACTIONS("transactions", "com.arjuna.ats.jts.orbspecific.jacorb.interceptors.interposition.InterpositionORBInitializerImpl", "com.arjuna.ats.jbossatx.jts.InboundTransactionCurrentInitializer", "org.jboss.as.jacorb.tm.TxIORInterceptorInitializer", "org.jboss.as.jacorb.tm.TxServerInterceptorInitializer"),
    SPEC_TRANSACTIONS("specTransactions", "org.jboss.as.jacorb.tm.TxServerInterceptorInitializer");

    private final String initializerName;
    private final String[] initializerClasses;
    private static final Map<String, ORBInitializer> MAP;

    private ORBInitializer(String initializerName, String ... initializerClasses) {
        this.initializerName = initializerName;
        this.initializerClasses = initializerClasses;
    }

    public String getInitializerName() {
        return this.initializerName;
    }

    public String[] getInitializerClasses() {
        return this.initializerClasses;
    }

    static ORBInitializer fromName(String initializerName) {
        ORBInitializer element = MAP.get(initializerName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, ORBInitializer> map = new HashMap<String, ORBInitializer>();
        for (ORBInitializer element : ORBInitializer.values()) {
            String name = element.getInitializerName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

