/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterRef;
import org.wildfly.extension.undertow.filters.FilterService;

public class FilterRefDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition PREDICATE = new SimpleAttributeDefinitionBuilder("predicate", ModelType.STRING).setAllowNull(true).setAllowExpression(true).build();
    public static final AttributeDefinition PRIORITY = new SimpleAttributeDefinitionBuilder("priority", ModelType.INT).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode(1)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true)).build();
    public static final FilterRefDefinition INSTANCE = new FilterRefDefinition();

    private FilterRefDefinition() {
        super(UndertowExtension.PATH_FILTER_REF, (ResourceDescriptionResolver)UndertowExtension.getResolver("filter-ref"), (OperationStepHandler)new FilterRefAdd(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PREDICATE, PRIORITY);
    }

    static class FilterRefAdd
    extends AbstractAddStepHandler {
        FilterRefAdd() {
            super(new AttributeDefinition[]{PREDICATE, PRIORITY});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String name = address.getLastElement().getValue();
            Predicate predicate = null;
            if (model.hasDefined(PREDICATE.getName())) {
                String predicateString = model.get(PREDICATE.getName()).asString();
                predicate = PredicateParser.parse((String)predicateString, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            int priority = PRIORITY.resolveModelAttribute(context, operation).asInt();
            FilterRef service = new FilterRef(predicate, priority);
            ServiceTarget target = context.getServiceTarget();
            ServiceController sc = target.addService(UndertowService.getFilterRefServiceName(address, name), (Service)service).addDependency(UndertowService.FILTER.append(new String[]{name}), FilterService.class, service.getFilter()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (newControllers != null) {
                newControllers.add(sc);
            }
        }
    }
}

