/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProvider;

public abstract class ShardIdentifierProviderTemplate
implements ShardIdentifierProvider {
    private volatile Set<String> knownShards = Collections.emptySet();

    @Override
    public final void initialize(Properties properties, BuildContext buildContext) {
        Set<String> initialShardNames = this.loadInitialShardNames(properties, buildContext);
        this.knownShards = Collections.unmodifiableSet(new HashSet<String>(initialShardNames));
    }

    protected abstract Set<String> loadInitialShardNames(Properties var1, BuildContext var2);

    protected final void addShard(String shardName) {
        if (!this.knownShards.contains(shardName)) {
            this.addShardSynchronized(shardName);
        }
    }

    private synchronized void addShardSynchronized(String shardName) {
        HashSet<String> newCopy = new HashSet<String>(this.knownShards);
        newCopy.add(shardName);
        this.knownShards = Collections.unmodifiableSet(newCopy);
    }

    @Override
    public final Set<String> getAllShardIdentifiers() {
        return this.knownShards;
    }

    @Override
    public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.getAllShardIdentifiers();
    }
}

