/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.management.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.core.management.HornetQServerControl;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.management.impl.MBeanInfoHelper;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.jms.management.impl.JMSQueueControlImpl;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.utils.json.JSONArray;
import org.hornetq.utils.json.JSONObject;

public class JMSTopicControlImpl
extends StandardMBean
implements TopicControl {
    private final HornetQDestination managedTopic;
    private final AddressControl addressControl;
    private final ManagementService managementService;
    private final JMSServerManager jmsServerManager;

    public static String createFilterFromJMSSelector(String selectorStr) throws HornetQException {
        return selectorStr == null || selectorStr.trim().length() == 0 ? null : SelectorTranslator.convertToHornetQFilterString((String)selectorStr);
    }

    public JMSTopicControlImpl(HornetQDestination topic, JMSServerManager jmsServerManager, AddressControl addressControl, ManagementService managementService) throws Exception {
        super(TopicControl.class);
        this.jmsServerManager = jmsServerManager;
        this.managedTopic = topic;
        this.addressControl = addressControl;
        this.managementService = managementService;
    }

    public void addJNDI(String jndi) throws Exception {
        this.jmsServerManager.addTopicToJndi(this.managedTopic.getName(), jndi);
    }

    public String[] getJNDIBindings() {
        return this.jmsServerManager.getJNDIOnTopic(this.managedTopic.getName());
    }

    public String getName() {
        return this.managedTopic.getName();
    }

    public boolean isTemporary() {
        return this.managedTopic.isTemporary();
    }

    public String getAddress() {
        return this.managedTopic.getAddress();
    }

    public long getMessageCount() {
        return this.getMessageCount(DurabilityType.ALL);
    }

    public int getDeliveringCount() {
        List<QueueControl> queues = this.getQueues(DurabilityType.ALL);
        int count = 0;
        for (QueueControl queue : queues) {
            count += queue.getDeliveringCount();
        }
        return count;
    }

    public long getMessagesAdded() {
        List<QueueControl> queues = this.getQueues(DurabilityType.ALL);
        int count = 0;
        for (QueueControl queue : queues) {
            count = (int)((long)count + queue.getMessagesAdded());
        }
        return count;
    }

    public int getDurableMessageCount() {
        return this.getMessageCount(DurabilityType.DURABLE);
    }

    public int getNonDurableMessageCount() {
        return this.getMessageCount(DurabilityType.NON_DURABLE);
    }

    public int getSubscriptionCount() {
        return this.getQueues(DurabilityType.ALL).size();
    }

    public int getDurableSubscriptionCount() {
        return this.getQueues(DurabilityType.DURABLE).size();
    }

    public int getNonDurableSubscriptionCount() {
        return this.getQueues(DurabilityType.NON_DURABLE).size();
    }

    public Object[] listAllSubscriptions() {
        return this.listSubscribersInfos(DurabilityType.ALL);
    }

    public String listAllSubscriptionsAsJSON() throws Exception {
        return this.listSubscribersInfosAsJSON(DurabilityType.ALL);
    }

    public Object[] listDurableSubscriptions() {
        return this.listSubscribersInfos(DurabilityType.DURABLE);
    }

    public String listDurableSubscriptionsAsJSON() throws Exception {
        return this.listSubscribersInfosAsJSON(DurabilityType.DURABLE);
    }

    public Object[] listNonDurableSubscriptions() {
        return this.listSubscribersInfos(DurabilityType.NON_DURABLE);
    }

    public String listNonDurableSubscriptionsAsJSON() throws Exception {
        return this.listSubscribersInfosAsJSON(DurabilityType.NON_DURABLE);
    }

    public Map<String, Object>[] listMessagesForSubscription(String queueName) throws Exception {
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName);
        }
        Map[] coreMessages = coreQueueControl.listMessages(null);
        Map[] jmsMessages = new Map[coreMessages.length];
        int i = 0;
        for (Map coreMessage : coreMessages) {
            jmsMessages[i++] = HornetQMessage.coreMaptoJMSMap((Map)coreMessage);
        }
        return jmsMessages;
    }

    public String listMessagesForSubscriptionAsJSON(String queueName) throws Exception {
        return JMSQueueControlImpl.toJSON(this.listMessagesForSubscription(queueName));
    }

    public int countMessagesForSubscription(String clientID, String subscriptionName, String filterStr) throws Exception {
        String queueName = HornetQDestination.createQueueNameForDurableSubscription((boolean)true, (String)clientID, (String)subscriptionName);
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName + " for clientID " + clientID);
        }
        String filter = JMSTopicControlImpl.createFilterFromJMSSelector(filterStr);
        return coreQueueControl.listMessages(filter).length;
    }

    public int removeMessages(String filterStr) throws Exception {
        String[] queues;
        String filter = JMSTopicControlImpl.createFilterFromJMSSelector(filterStr);
        int count = 0;
        for (String queue : queues = this.addressControl.getQueueNames()) {
            QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queue);
            if (coreQueueControl == null) continue;
            count += coreQueueControl.removeMessages(filter);
        }
        return count;
    }

    public void dropDurableSubscription(String clientID, String subscriptionName) throws Exception {
        String queueName = HornetQDestination.createQueueNameForDurableSubscription((boolean)true, (String)clientID, (String)subscriptionName);
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queueName);
        if (coreQueueControl == null) {
            throw new IllegalArgumentException("No subscriptions with name " + queueName + " for clientID " + clientID);
        }
        HornetQServerControl serverControl = (HornetQServerControl)this.managementService.getResource("core.server");
        serverControl.destroyQueue(queueName);
    }

    public void dropAllSubscriptions() throws Exception {
        String[] queues;
        HornetQServerControl serverControl = (HornetQServerControl)this.managementService.getResource("core.server");
        for (String queue : queues = this.addressControl.getQueueNames()) {
            if (queue.equals(this.managedTopic.getAddress())) continue;
            serverControl.destroyQueue(queue);
        }
    }

    private Object[] listSubscribersInfos(DurabilityType durability) {
        List<QueueControl> queues = this.getQueues(durability);
        ArrayList<Object[]> subInfos = new ArrayList<Object[]>(queues.size());
        for (QueueControl queue : queues) {
            String clientID = null;
            String subName = null;
            if (queue.isDurable()) {
                Pair pair = HornetQDestination.decomposeQueueNameForDurableSubscription((String)queue.getName().toString());
                clientID = (String)pair.getA();
                subName = (String)pair.getB();
            }
            String filter = queue.getFilter() != null ? queue.getFilter() : null;
            Object[] subscriptionInfo = new Object[]{queue.getName(), clientID, subName, queue.isDurable(), queue.getMessageCount(), filter};
            subInfos.add(subscriptionInfo);
        }
        return subInfos.toArray(new Object[subInfos.size()]);
    }

    private String listSubscribersInfosAsJSON(DurabilityType durability) throws Exception {
        try {
            List<QueueControl> queues = this.getQueues(durability);
            JSONArray array = new JSONArray();
            for (QueueControl queue : queues) {
                String clientID = null;
                String subName = null;
                if (queue.isDurable() && !queue.getName().startsWith("jms.topic.")) {
                    Pair pair = HornetQDestination.decomposeQueueNameForDurableSubscription((String)queue.getName().toString());
                    clientID = (String)pair.getA();
                    subName = (String)pair.getB();
                } else if (queue.getName().startsWith("jms.topic.")) {
                    clientID = "HornetQ";
                    subName = "HornetQ";
                }
                String filter = queue.getFilter() != null ? queue.getFilter() : null;
                JSONObject info = new JSONObject();
                info.put("queueName", (Object)queue.getName());
                info.put("clientID", (Object)clientID);
                info.put("selector", (Object)filter);
                info.put("name", (Object)subName);
                info.put("durable", queue.isDurable());
                info.put("messageCount", queue.getMessageCount());
                info.put("deliveringCount", queue.getDeliveringCount());
                info.put("consumers", (Object)new JSONArray(queue.listConsumersAsJSON()));
                array.put((Object)info);
            }
            return array.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    private int getMessageCount(DurabilityType durability) {
        List<QueueControl> queues = this.getQueues(durability);
        int count = 0;
        for (QueueControl queue : queues) {
            count = (int)((long)count + queue.getMessageCount());
        }
        return count;
    }

    private List<QueueControl> getQueues(DurabilityType durability) {
        try {
            String[] queues;
            ArrayList<QueueControl> matchingQueues = new ArrayList<QueueControl>();
            for (String queue : queues = this.addressControl.getQueueNames()) {
                QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queue);
                if (coreQueueControl == null || coreQueueControl.getName().equals(this.addressControl.getAddress()) || durability != DurabilityType.ALL && (durability != DurabilityType.DURABLE || !coreQueueControl.isDurable()) && (durability != DurabilityType.NON_DURABLE || coreQueueControl.isDurable())) continue;
                matchingQueues.add(coreQueueControl);
            }
            return matchingQueues;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        return new MBeanInfo(info.getClassName(), info.getDescription(), info.getAttributes(), info.getConstructors(), MBeanInfoHelper.getMBeanOperationsInfo(TopicControl.class), info.getNotifications());
    }

    private static enum DurabilityType {
        ALL,
        DURABLE,
        NON_DURABLE;

    }
}

