/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.query.remote.DelegatingSerializationContext;
import org.infinispan.query.remote.ProtobufMetadataManagerInterceptor;
import org.infinispan.query.remote.client.MarshallerRegistration;
import org.infinispan.query.remote.client.ProtobufMetadataManagerMBean;
import org.infinispan.query.remote.indexing.IndexingMetadataCreator;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ProtobufMetadataManager", description="Component that acts as a manager and container for Protocol Buffers message type definitions in the scope of a CacheManger.")
public final class ProtobufMetadataManager
implements ProtobufMetadataManagerMBean {
    private Cache<String, String> protobufSchemaCache;
    private ObjectName objectName;
    private final SerializationContext serCtx;
    private EmbeddedCacheManager cacheManager;

    public ProtobufMetadataManager() {
        Configuration.Builder configBuilder = new Configuration.Builder();
        configBuilder.messageAnnotation("Indexed").attribute("value").booleanType().defaultValue((Object)true).annotationMetadataCreator((AnnotationMetadataCreator)new IndexingMetadataCreator()).fieldAnnotation("IndexedField").attribute("index").booleanType().defaultValue((Object)true).attribute("store").booleanType().defaultValue((Object)true);
        this.serCtx = ProtobufUtil.newSerializationContext((Configuration)configBuilder.build());
        try {
            MarshallerRegistration.registerMarshallers((SerializationContext)this.serCtx);
        }
        catch (IOException | DescriptorParserException e) {
            throw new CacheException("Failed to initialise the Protobuf serialization context", e);
        }
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        internalCacheRegistry.registerInternalCache("___protobuf_metadata", this.getProtobufMetadataCacheConfig().build(), EnumSet.of(InternalCacheRegistry.Flag.USER));
    }

    Cache<String, String> getCache() {
        if (this.protobufSchemaCache == null) {
            this.protobufSchemaCache = this.cacheManager.getCache("___protobuf_metadata");
        }
        return this.protobufSchemaCache;
    }

    private ConfigurationBuilder getProtobufMetadataCacheConfig() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        CacheMode cacheMode = globalConfiguration.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().transaction().lockingMode(LockingMode.PESSIMISTIC).syncCommitPhase(true).syncRollbackPhase(true).locking().isolationLevel(IsolationLevel.READ_COMMITTED).useLockStriping(false).clustering().cacheMode(cacheMode).sync().stateTransfer().fetchInMemoryState(true).awaitInitialTransfer(false).compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller()).customInterceptors().addInterceptor().interceptor((CommandInterceptor)new ProtobufMetadataManagerInterceptor()).after(PessimisticLockingInterceptor.class);
        return cfg;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        this.serCtx.registerMarshaller(marshaller);
    }

    @ManagedOperation(description="Registers a Protobuf definition file", displayName="Register Protofile")
    public void registerProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName, @Parameter(name="contents", description="contents of the file") String contents) {
        this.getCache().put((Object)fileName, (Object)contents);
    }

    @ManagedOperation(description="Registers a set of Protobuf definition files", displayName="Register Protofiles")
    public void registerProtofiles(@Parameter(name="fileNames", description="names of the protofiles") String[] fileNames, @Parameter(name="fileContents", description="content of the files") String[] contents) throws Exception {
        if (fileNames.length != contents.length) {
            throw new MBeanException(new IllegalArgumentException("invalid parameter sizes"));
        }
        HashMap<String, String> files = new HashMap<String, String>(fileNames.length);
        for (int i = 0; i < fileNames.length; ++i) {
            files.put(fileNames[i], contents[i]);
        }
        this.getCache().putAll(files);
    }

    @ManagedAttribute(description="The names of all Protobuf files", displayName="Protofile Names")
    public String[] getProtofileNames() {
        HashSet<String> fileNames = new HashSet<String>();
        for (String k : this.getCache().keySet()) {
            if (!k.endsWith(".proto")) continue;
            fileNames.add(k);
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @ManagedOperation(description="Get the contents of a protobuf definition file", displayName="Get Protofile")
    public String getProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (!fileName.endsWith(".proto")) {
            throw new IllegalArgumentException("The file name must have \".proto\" suffix");
        }
        return (String)this.getCache().get((Object)fileName);
    }

    @ManagedAttribute(description="The names of the files that have errors, if any", displayName="Files With Errors")
    public String[] getFilesWithErrors() {
        String filesWithErrors = (String)this.getCache().get((Object)".errors");
        if (filesWithErrors == null) {
            return null;
        }
        return filesWithErrors.split("\n");
    }

    @ManagedOperation(description="Obtains the errors associated with a protobuf definition file", displayName="Get Errors For A File")
    public String getFileErrors(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        if (!fileName.endsWith(".proto")) {
            throw new IllegalArgumentException("The file name must have \".proto\" suffix");
        }
        return (String)this.getCache().get((Object)(fileName + ".errors"));
    }

    @Deprecated
    public void registerProtofiles(String ... classPathResources) throws Exception {
        HashMap<String, String> files = new HashMap<String, String>(classPathResources.length);
        for (String classPathResource : classPathResources) {
            String absPath = classPathResource.startsWith("/") ? classPathResource : "/" + classPathResource;
            String path = classPathResource.startsWith("/") ? classPathResource.substring(1) : classPathResource;
            files.put(path, Util.read((InputStream)Util.getResourceAsStream((String)absPath, (ClassLoader)this.getClass().getClassLoader())));
        }
        this.getCache().putAll(files);
    }

    @Deprecated
    @ManagedOperation(description="Display a protobuf definition file", displayName="Display Protofile")
    public String displayProtofile(@Parameter(name="fileName", description="the name of the .proto file") String fileName) {
        return this.getProtofile(fileName);
    }

    SerializationContext getSerializationContext() {
        return this.serCtx;
    }

    public static SerializationContext getSerializationContext(EmbeddedCacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager cannot be null");
        }
        ProtobufMetadataManager metadataManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (metadataManager == null) {
            throw new IllegalStateException("ProtobufMetadataManager not initialised yet!");
        }
        return new DelegatingSerializationContext(metadataManager);
    }

    public static SerializationContext getSerializationContextInternal(EmbeddedCacheManager cacheManager) {
        DelegatingSerializationContext delegatingCtx = (DelegatingSerializationContext)ProtobufMetadataManager.getSerializationContext(cacheManager);
        return delegatingCtx.getDelegate();
    }
}

