/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.SecurityActions;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.indexing.IndexingMetadata;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.util.KeyValuePair;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";
    private final QueryParser queryParser = new QueryParser();

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        try {
            QueryResponse response;
            SerializationContext serCtx = ProtobufMetadataManager.getSerializationContextInternal(cache.getCacheManager());
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
            if (cacheConfiguration.indexing().index().isEnabled()) {
                try {
                    response = this.executeIndexedQuery(cache, cacheConfiguration, serCtx, request);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().contains("ISPN018002")) {
                        response = this.executeNonIndexedQuery(cache, cacheConfiguration, serCtx, request);
                    }
                    throw e;
                }
            } else {
                response = this.executeNonIndexedQuery(cache, cacheConfiguration, serCtx, request);
            }
            return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    private QueryResponse executeNonIndexedQuery(AdvancedCache<byte[], byte[]> cache, Configuration cacheConfiguration, SerializationContext serCtx, QueryRequest request) throws IOException {
        boolean isIndexed = cacheConfiguration.indexing().index().isEnabled();
        boolean isCompatMode = cacheConfiguration.compatibility().enabled();
        EmbeddedQuery eq = new EmbeddedQuery(null, cache, this.makeFilter(cache, isIndexed, isCompatMode, request.getJpqlString()), request.getStartOffset(), request.getMaxResults());
        List list = eq.list();
        int projSize = eq.getProjection() != null && eq.getProjection().length > 0 ? eq.getProjection().length : 0;
        return this.makeResponse(isCompatMode, serCtx, list, projSize, eq.getResultSize(), list.size());
    }

    private JPAFilterAndConverter makeFilter(final AdvancedCache<?, ?> cache, final boolean isIndexed, final boolean isCompatMode, final String jpaQuery) {
        return SecurityActions.doPrivileged(new PrivilegedAction<JPAFilterAndConverter>(){

            @Override
            public JPAFilterAndConverter run() {
                JPAProtobufFilterAndConverter filter = isIndexed && !isCompatMode ? new JPAProtobufFilterAndConverter(jpaQuery) : new JPAFilterAndConverter(jpaQuery, isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
                filter.injectDependencies((Cache)cache);
                filter.getObjectFilter();
                return filter;
            }
        });
    }

    private QueryResponse executeIndexedQuery(AdvancedCache<byte[], byte[]> cache, Configuration cacheConfiguration, SerializationContext serCtx, QueryRequest request) throws IOException {
        LuceneQueryParsingResult parsingResult;
        SearchManager searchManager = Search.getSearchManager(cache);
        SearchIntegrator searchFactory = (SearchIntegrator)searchManager.unwrap(SearchIntegrator.class);
        QueryCache queryCache = ComponentRegistryUtils.getQueryCache(cache);
        if (queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)request.getJpqlString(), LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)queryCache.get(queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.parseQuery(cacheConfiguration, serCtx, request.getJpqlString(), searchFactory);
                queryCache.put(queryCacheKey, (Object)parsingResult);
            }
        } else {
            parsingResult = this.parseQuery(cacheConfiguration, serCtx, request.getJpqlString(), searchFactory);
        }
        Query luceneQuery = parsingResult.getQuery();
        boolean isCompatMode = cacheConfiguration.compatibility().enabled();
        if (!isCompatMode) {
            QueryBuilder qb = searchFactory.buildQueryBuilder().forEntity(parsingResult.getTargetEntity()).get();
            luceneQuery = qb.bool().must(((TermMatchingContext)((TermMatchingContext)qb.keyword().onField(TYPE_FIELD_NAME).ignoreFieldBridge()).ignoreAnalyzer()).matching((Object)parsingResult.getTargetEntityName()).createQuery()).must(luceneQuery).createQuery();
        }
        CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[]{parsingResult.getTargetEntity()});
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        int projSize = 0;
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            projSize = parsingResult.getProjections().size();
            cacheQuery = cacheQuery.projection(parsingResult.getProjections().toArray(new String[projSize]));
        }
        if (request.getStartOffset() > 0L) {
            cacheQuery = cacheQuery.firstResult((int)request.getStartOffset());
        }
        if (request.getMaxResults() > 0) {
            cacheQuery = cacheQuery.maxResults(request.getMaxResults());
        }
        List list = cacheQuery.list();
        return this.makeResponse(false, serCtx, list, projSize, cacheQuery.getResultSize(), list.size());
    }

    private LuceneQueryParsingResult parseQuery(Configuration cacheConfiguration, final SerializationContext serCtx, String queryString, SearchIntegrator searchFactory) {
        LuceneProcessingChain processingChain;
        if (cacheConfiguration.compatibility().enabled()) {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? serCtx.getMarshaller(entityName).getJavaClass() : null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities();
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    Descriptor md = serCtx.getMessageDescriptor(type);
                    FieldDescriptor fd = QueryFacadeImpl.this.getFieldDescriptor(md, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return NumericFieldBridge.DOUBLE_FIELD_BRIDGE;
                        }
                        case FLOAT: {
                            return NumericFieldBridge.FLOAT_FIELD_BRIDGE;
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return NumericFieldBridge.LONG_FIELD_BRIDGE;
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return NumericFieldBridge.INT_FIELD_BRIDGE;
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), QueryFacadeImpl.NULL_TOKEN);
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
        }
        return (LuceneQueryParsingResult)this.queryParser.parseQuery(queryString, (AstProcessingChain)processingChain);
    }

    private FieldDescriptor getFieldDescriptor(Descriptor messageDescriptor, String attributePath) {
        FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) {
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }

    private QueryResponse makeResponse(boolean isCompatMode, SerializationContext serCtx, List<?> list, int projSize, long totalResults, int numResults) throws IOException {
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                if (isCompatMode) {
                    o = ProtobufUtil.toWrappedByteArray((SerializationContext)serCtx, o);
                }
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults(totalResults);
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

