/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.commons.util.concurrent.jdk8backported.BoundedEquivalentConcurrentHashMapV8;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataImmortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientCacheEntry;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class CacheEntrySizeCalculator<K, V>
extends BoundedEquivalentConcurrentHashMapV8.AbstractSizeCalculatorHelper<K, InternalCacheEntry<K, V>> {
    private final BoundedEquivalentConcurrentHashMapV8.EntrySizeCalculator<? super K, ? super V> calculator;

    public CacheEntrySizeCalculator(BoundedEquivalentConcurrentHashMapV8.EntrySizeCalculator<? super K, ? super V> calculator) {
        this.calculator = calculator;
    }

    public long calculateSize(K key, InternalCacheEntry<K, V> ice) {
        boolean metadataAware;
        boolean transientEntry;
        boolean mortalEntry;
        long objSize = this.calculator.calculateSize(key, ice.getValue());
        long iceSize = 0L;
        long metadataSize = 0L;
        iceSize += (long)(OBJECT_SIZE + POINTER_SIZE);
        iceSize += (long)(2 * POINTER_SIZE);
        if (ice instanceof MetadataImmortalCacheEntry) {
            mortalEntry = false;
            transientEntry = false;
            metadataAware = true;
        } else if (ice instanceof ImmortalCacheEntry) {
            mortalEntry = false;
            transientEntry = false;
            metadataAware = false;
        } else if (ice instanceof MortalCacheEntry) {
            mortalEntry = true;
            transientEntry = false;
            metadataAware = false;
        } else if (ice instanceof TransientCacheEntry) {
            mortalEntry = false;
            transientEntry = true;
            metadataAware = false;
        } else if (ice instanceof TransientMortalCacheEntry) {
            mortalEntry = true;
            transientEntry = true;
            metadataAware = false;
        } else if (ice instanceof MetadataMortalCacheEntry) {
            mortalEntry = true;
            transientEntry = false;
            metadataAware = true;
        } else if (ice instanceof MetadataTransientCacheEntry) {
            mortalEntry = false;
            transientEntry = true;
            metadataAware = true;
        } else if (ice instanceof MetadataTransientMortalCacheEntry) {
            mortalEntry = true;
            transientEntry = true;
            metadataAware = true;
        } else {
            mortalEntry = false;
            transientEntry = false;
            metadataAware = false;
        }
        if (metadataAware) {
            iceSize += (long)POINTER_SIZE;
            metadataSize += (long)(OBJECT_SIZE + POINTER_SIZE);
            Metadata metadata = ice.getMetadata();
            if (metadata instanceof EmbeddedMetadata) {
                metadataSize += (long)POINTER_SIZE;
                metadataSize = this.roundUpToNearest8(metadataSize);
                metadataSize += (long)(OBJECT_SIZE + POINTER_SIZE + 8);
                metadataSize = this.roundUpToNearest8(metadataSize);
            }
        }
        iceSize += mortalEntry ? 16L : 0L;
        return objSize + this.roundUpToNearest8(iceSize += transientEntry ? 16L : 0L) + metadataSize;
    }
}

