/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.Response;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.BlockingRunnable;

public abstract class BaseBlockingRunnable
implements BlockingRunnable {
    protected final BasePerCacheInboundInvocationHandler handler;
    protected final CacheRpcCommand command;
    protected final Reply reply;
    protected Response response;

    protected BaseBlockingRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply) {
        this.handler = handler;
        this.command = command;
        this.reply = reply;
    }

    @Override
    public void run() {
        try {
            this.response = this.beforeInvoke();
            if (this.response == null) {
                this.response = this.handler.invokePerform(this.command);
            }
            this.afterInvoke();
        }
        catch (InterruptedException e) {
            this.response = this.handler.interruptedException(this.command);
            this.onException(e);
        }
        catch (OutdatedTopologyException oe) {
            this.response = this.handler.outdatedTopology(oe);
            this.onException((Throwable)((Object)oe));
        }
        catch (Exception e) {
            this.response = this.handler.exceptionHandlingCommand(this.command, e);
            this.onException(e);
        }
        catch (Throwable throwable) {
            this.response = this.handler.exceptionHandlingCommand(this.command, throwable);
            this.onException(throwable);
        }
        finally {
            this.reply.reply(this.response);
            this.onFinally();
        }
    }

    protected void onFinally() {
    }

    protected void onException(Throwable throwable) {
    }

    protected void afterInvoke() {
    }

    protected Response beforeInvoke() throws Exception {
        return null;
    }
}

