/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import org.apache.lucene.search.TopDocs;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.ISPNEagerTopDocs;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.ClusteredQueryCommandWorker;
import org.infinispan.query.clustered.commandworkers.QueryExtractorUtil;

public class CQCreateEagerQuery
extends ClusteredQueryCommandWorker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse perform() {
        this.query.afterDeserialise(this.getSearchFactory());
        try (DocumentExtractor extractor = this.query.queryDocumentExtractor();){
            int resultSize = this.query.queryResultSize();
            ISPNEagerTopDocs eagerTopDocs = this.collectKeys(extractor);
            QueryResponse queryResponse = new QueryResponse(eagerTopDocs, this.getQueryBox().getMyId(), resultSize);
            queryResponse.setAddress(this.cache.getAdvancedCache().getRpcManager().getAddress());
            QueryResponse queryResponse2 = queryResponse;
            return queryResponse2;
        }
    }

    private ISPNEagerTopDocs collectKeys(DocumentExtractor extractor) {
        TopDocs topDocs = extractor.getTopDocs();
        Object[] keys = new Object[topDocs.scoreDocs.length];
        KeyTransformationHandler keyTransformationHandler = KeyTransformationHandler.getInstance(this.cache.getAdvancedCache());
        for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
            keys[i] = QueryExtractorUtil.extractKey(extractor, this.cache, keyTransformationHandler, i);
        }
        return new ISPNEagerTopDocs(topDocs, keys);
    }
}

