/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.SecurityActions;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;

public class EmbeddedQuery
extends BaseQuery {
    private static final int INITIAL_CAPACITY = 1000;
    private final AdvancedCache<?, ?> cache;
    private final JPAFilterAndConverter filter;
    private List results;
    private int resultSize;
    private final String[] projection;
    private final int startOffset;
    private final int maxResults;

    public EmbeddedQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, JPAFilterAndConverter filter, long startOffset, int maxResults) {
        super(queryFactory, filter.getJPAQuery());
        this.ensureAccessPermissions(cache);
        this.cache = cache;
        this.startOffset = startOffset < 0L ? 0 : (int)startOffset;
        this.maxResults = maxResults;
        this.filter = filter;
        this.projection = filter.getObjectFilter().getProjection();
    }

    private void ensureAccessPermissions(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
    }

    public String[] getProjection() {
        return this.projection;
    }

    public <T> List<T> list() {
        if (this.results == null) {
            this.results = this.listInternal();
        }
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List listInternal() {
        List<Object> results;
        CloseableIterable iterable = this.cache.filterEntries((KeyValueFilter)this.filter).converter((Converter)this.filter);
        Comparator comparator = this.filter.getObjectFilter().getComparator();
        if (comparator == null) {
            results = new ArrayList(1000);
            try {
                for (Map.Entry entry : iterable) {
                    ++this.resultSize;
                    if (this.resultSize <= this.startOffset || this.maxResults != -1 && results.size() >= this.maxResults) continue;
                    ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)entry.getValue();
                    results.add(this.projection != null ? r.getProjection() : r.getInstance());
                }
            }
            finally {
                try {
                    iterable.close();
                }
                catch (Exception e) {}
            }
        }
        PriorityQueue<ObjectFilter.FilterResult> filterResults = new PriorityQueue<ObjectFilter.FilterResult>(1000, new ReverseFilterResultComparator(comparator));
        try {
            for (Map.Entry entry : iterable) {
                ++this.resultSize;
                filterResults.add((ObjectFilter.FilterResult)entry.getValue());
                if (this.maxResults == -1 || filterResults.size() <= this.startOffset + this.maxResults) continue;
                filterResults.remove();
            }
        }
        finally {
            try {
                iterable.close();
            }
            catch (Exception e) {}
        }
        if (filterResults.size() > this.startOffset) {
            Object[] res = new Object[filterResults.size() - this.startOffset];
            int i = filterResults.size();
            while (i-- > this.startOffset) {
                ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)filterResults.remove();
                res[i - this.startOffset] = this.projection != null ? r.getProjection() : r.getInstance();
            }
            results = Arrays.asList(res);
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public int getResultSize() {
        this.list();
        return this.resultSize;
    }

    public String toString() {
        return "EmbeddedQuery{jpaQuery=" + this.jpaQuery + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }

    private static class ReverseFilterResultComparator
    implements Comparator<ObjectFilter.FilterResult> {
        private final Comparator<Comparable[]> comparator;

        private ReverseFilterResultComparator(Comparator<Comparable[]> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectFilter.FilterResult o1, ObjectFilter.FilterResult o2) {
            return -this.comparator.compare(o1.getSortProjection(), o2.getSortProjection());
        }
    }
}

