/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.cache.ReplayCache;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;

public class SamlAssertionValidator
extends SignatureTrustValidator {
    private static final Log LOG = LogFactory.getLog(SamlAssertionValidator.class);
    private int futureTTL = 60;
    private boolean validateSignatureAgainstProfile = true;
    private String requiredSubjectConfirmationMethod;
    private boolean requireStandardSubjectConfirmationMethod = true;
    private boolean requireBearerSignature = true;

    public void setFutureTTL(int newFutureTTL) {
        this.futureTTL = newFutureTTL;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getAssertion() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        AssertionWrapper assertion = credential.getAssertion();
        this.verifySubjectConfirmationMethod(assertion);
        this.checkConditions(assertion);
        this.checkOneTimeUse(assertion, data);
        this.validateAssertion(assertion);
        if (assertion.isSigned()) {
            this.verifySignedAssertion(assertion, data);
        }
        return credential;
    }

    protected void verifySubjectConfirmationMethod(AssertionWrapper samlAssertion) throws WSSecurityException {
        List<String> methods = samlAssertion.getConfirmationMethods();
        if (methods == null || methods.isEmpty()) {
            if (this.requiredSubjectConfirmationMethod != null) {
                LOG.debug((Object)"A required subject confirmation method was not present");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            if (this.requireStandardSubjectConfirmationMethod) {
                LOG.debug((Object)"A standard subject confirmation method was not present");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        boolean signed = samlAssertion.isSigned();
        boolean requiredMethodFound = false;
        boolean standardMethodFound = false;
        for (String method : methods) {
            if (OpenSAMLUtil.isMethodHolderOfKey(method)) {
                if (samlAssertion.getSubjectKeyInfo() == null) {
                    LOG.debug((Object)"There is no Subject KeyInfo to match the holder-of-key subject conf method");
                    throw new WSSecurityException(0, "noKeyInSAMLToken");
                }
                if (!signed) {
                    LOG.debug((Object)"A holder-of-key assertion must be signed");
                    throw new WSSecurityException(0, "invalidSAMLsecurity");
                }
                standardMethodFound = true;
            }
            if (method == null) continue;
            if (method.equals(this.requiredSubjectConfirmationMethod)) {
                requiredMethodFound = true;
            }
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(method) || "urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(method)) {
                standardMethodFound = true;
                if (!this.requireBearerSignature || signed) continue;
                LOG.debug((Object)"A Bearer Assertion was not signed");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
            if (!"urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(method) && !"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(method)) continue;
            standardMethodFound = true;
        }
        if (!requiredMethodFound && this.requiredSubjectConfirmationMethod != null) {
            LOG.debug((Object)"A required subject confirmation method was not present");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (!standardMethodFound && this.requireStandardSubjectConfirmationMethod) {
            LOG.debug((Object)"A standard subject confirmation method was not present");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    protected Credential verifySignedAssertion(AssertionWrapper assertion, RequestData data) throws WSSecurityException {
        Credential trustCredential = new Credential();
        SAMLKeyInfo samlKeyInfo = assertion.getSignatureKeyInfo();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        return super.validate(trustCredential, data);
    }

    protected void checkConditions(AssertionWrapper assertion) throws WSSecurityException {
        DateTime validFrom = null;
        DateTime validTill = null;
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && assertion.getSaml2().getConditions() != null) {
            validFrom = assertion.getSaml2().getConditions().getNotBefore();
            validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
        } else if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_11) && assertion.getSaml1().getConditions() != null) {
            validFrom = assertion.getSaml1().getConditions().getNotBefore();
            validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
        }
        if (validFrom != null) {
            DateTime currentTime = new DateTime();
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(this.futureTTL)))) {
                LOG.debug((Object)"SAML Token condition (Not Before) not met");
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        if (validTill != null && validTill.isBeforeNow()) {
            LOG.debug((Object)"SAML Token condition (Not On Or After) not met");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    protected void checkOneTimeUse(AssertionWrapper samlAssertion, RequestData data) throws WSSecurityException {
        if (samlAssertion.getSamlVersion().equals(SAMLVersion.VERSION_20) && samlAssertion.getSaml2().getConditions() != null && samlAssertion.getSaml2().getConditions().getOneTimeUse() != null && data.getSamlOneTimeUseReplayCache() != null) {
            String identifier = samlAssertion.getId();
            ReplayCache replayCache = data.getSamlOneTimeUseReplayCache();
            if (replayCache.contains(identifier)) {
                throw new WSSecurityException(3, "badSamlToken", new Object[]{"A replay attack has been detected"});
            }
            DateTime expires = samlAssertion.getSaml2().getConditions().getNotOnOrAfter();
            if (expires != null) {
                Date rightNow = new Date();
                long currentTime = rightNow.getTime();
                long expiresTime = expires.getMillis();
                replayCache.add(identifier, 1L + (expiresTime - currentTime) / 1000L);
            } else {
                replayCache.add(identifier);
            }
            replayCache.add(identifier);
        }
    }

    protected void validateAssertion(AssertionWrapper assertion) throws WSSecurityException {
        if (this.validateSignatureAgainstProfile) {
            assertion.validateSignatureAgainstProfile();
        }
        if (assertion.getSaml1() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml1-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml1());
                specValidators.validate((XMLObject)assertion.getSaml1());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
        }
        if (assertion.getSaml2() != null) {
            ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
            ValidatorSuite specValidators = Configuration.getValidatorSuite((String)"saml2-core-spec-validator");
            try {
                schemaValidators.validate((XMLObject)assertion.getSaml2());
                specValidators.validate((XMLObject)assertion.getSaml2());
            }
            catch (ValidationException e) {
                LOG.debug((Object)("Saml Validation error: " + e.getMessage()), (Throwable)e);
                throw new WSSecurityException(0, "invalidSAMLsecurity", null, e);
            }
        }
    }

    public boolean isValidateSignatureAgainstProfile() {
        return this.validateSignatureAgainstProfile;
    }

    public void setValidateSignatureAgainstProfile(boolean validateSignatureAgainstProfile) {
        this.validateSignatureAgainstProfile = validateSignatureAgainstProfile;
    }

    public String getRequiredSubjectConfirmationMethod() {
        return this.requiredSubjectConfirmationMethod;
    }

    public void setRequiredSubjectConfirmationMethod(String requiredSubjectConfirmationMethod) {
        this.requiredSubjectConfirmationMethod = requiredSubjectConfirmationMethod;
    }

    public boolean isRequireStandardSubjectConfirmationMethod() {
        return this.requireStandardSubjectConfirmationMethod;
    }

    public void setRequireStandardSubjectConfirmationMethod(boolean requireStandardSubjectConfirmationMethod) {
        this.requireStandardSubjectConfirmationMethod = requireStandardSubjectConfirmationMethod;
    }

    public boolean isRequireBearerSignature() {
        return this.requireBearerSignature;
    }

    public void setRequireBearerSignature(boolean requireBearerSignature) {
        this.requireBearerSignature = requireBearerSignature;
    }
}

