/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.sasl.callback.DigestHashCallback;

public class SaslClientCallbackHandler
implements CallbackHandler {
    private final String realm;
    private final String name;
    private final String credential;

    public SaslClientCallbackHandler(String realm, String name, String credential) {
        this.realm = realm;
        this.name = name;
        this.credential = credential;
    }

    public SaslClientCallbackHandler(String name, String credential) {
        int realmSep = name.indexOf(64);
        this.realm = realmSep < 0 ? "" : name.substring(realmSep + 1);
        this.name = realmSep < 0 ? name : name.substring(0, realmSep);
        this.credential = credential;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.credential.toCharArray());
                continue;
            }
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.name);
                continue;
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(this.realm);
                continue;
            }
            if (!(callback instanceof DigestHashCallback)) continue;
            ((DigestHashCallback)callback).setHexHash(this.credential);
        }
    }
}

