/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Arrays;
import java.util.Collection;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;

public class RequestOptions {
    protected ResponseMode mode = ResponseMode.GET_ALL;
    protected long timeout;
    protected boolean use_anycasting;
    protected boolean use_anycast_addresses;
    protected RspFilter rsp_filter;
    protected short scope;
    protected short flags;
    protected short transient_flags;
    protected Address[] exclusion_list;

    public RequestOptions() {
    }

    public RequestOptions(ResponseMode mode, long timeout, boolean use_anycasting, RspFilter rsp_filter, Message.Flag ... flags) {
        this(mode, timeout, use_anycasting, rsp_filter, 0);
        this.setFlags(flags);
    }

    public RequestOptions(ResponseMode mode, long timeout, boolean use_anycasting, RspFilter rsp_filter, short flags) {
        this.mode = mode;
        this.timeout = timeout;
        this.use_anycasting = use_anycasting;
        this.rsp_filter = rsp_filter;
        this.flags = flags;
    }

    public RequestOptions(ResponseMode mode, long timeout, boolean use_anycasting, RspFilter rsp_filter) {
        this(mode, timeout, use_anycasting, rsp_filter, null);
    }

    public RequestOptions(ResponseMode mode, long timeout) {
        this(mode, timeout, false, null);
    }

    public RequestOptions(ResponseMode mode, long timeout, boolean use_anycasting) {
        this(mode, timeout, use_anycasting, null);
    }

    public RequestOptions(RequestOptions opts) {
        this.mode = opts.mode;
        this.timeout = opts.timeout;
        this.use_anycasting = opts.use_anycasting;
        this.rsp_filter = opts.rsp_filter;
        this.scope = opts.scope;
        this.flags = opts.flags;
        this.transient_flags = opts.transient_flags;
        this.exclusion_list = opts.exclusion_list;
    }

    public static RequestOptions SYNC() {
        return new RequestOptions(ResponseMode.GET_ALL, 10000L);
    }

    public static RequestOptions ASYNC() {
        return new RequestOptions(ResponseMode.GET_NONE, 10000L);
    }

    public ResponseMode getMode() {
        return this.mode;
    }

    public RequestOptions setMode(ResponseMode mode) {
        this.mode = mode;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestOptions setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean getAnycasting() {
        return this.use_anycasting;
    }

    public RequestOptions setAnycasting(boolean use_anycasting) {
        this.use_anycasting = use_anycasting;
        return this;
    }

    public boolean useAnycastAddresses() {
        return this.use_anycast_addresses;
    }

    public RequestOptions useAnycastAddresses(boolean flag) {
        this.use_anycast_addresses = flag;
        return this;
    }

    public short getScope() {
        return this.scope;
    }

    public RequestOptions setScope(short scope) {
        this.scope = scope;
        return this;
    }

    public RspFilter getRspFilter() {
        return this.rsp_filter;
    }

    public RequestOptions setRspFilter(RspFilter rsp_filter) {
        this.rsp_filter = rsp_filter;
        return this;
    }

    public short getFlags() {
        return this.flags;
    }

    public short getTransientFlags() {
        return this.transient_flags;
    }

    public boolean isFlagSet(Message.Flag flag) {
        return flag != null && (this.flags & flag.value()) == flag.value();
    }

    public boolean isTransientFlagSet(Message.TransientFlag flag) {
        return flag != null && (this.transient_flags & flag.value()) == flag.value();
    }

    public RequestOptions setFlags(Message.Flag ... flags) {
        if (flags != null) {
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags | flag.value());
            }
        }
        return this;
    }

    public RequestOptions setTransientFlags(Message.TransientFlag ... flags) {
        if (flags != null) {
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (short)(this.transient_flags | flag.value());
            }
        }
        return this;
    }

    public RequestOptions clearFlags(Message.Flag ... flags) {
        if (flags != null) {
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                this.flags = (short)(this.flags & ~flag.value());
            }
        }
        return this;
    }

    public RequestOptions clearTransientFlags(Message.TransientFlag ... flags) {
        if (flags != null) {
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                this.transient_flags = (short)(this.transient_flags & ~flag.value());
            }
        }
        return this;
    }

    public boolean hasExclusionList() {
        return this.exclusion_list != null;
    }

    @Deprecated
    public Collection<Address> getExclusionList() {
        return this.exclusion_list == null ? null : Arrays.asList(this.exclusion_list);
    }

    public Address[] exclusionList() {
        return this.exclusion_list;
    }

    public RequestOptions setExclusionList(Address ... mbrs) {
        if (mbrs == null || mbrs.length == 0) {
            return this;
        }
        this.exclusion_list = mbrs;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mode=" + (Object)((Object)this.mode));
        sb.append(", timeout=" + this.timeout);
        if (this.use_anycasting) {
            sb.append(", anycasting=true");
            if (this.use_anycast_addresses) {
                sb.append(" (using AnycastAddress)");
            }
        }
        if (this.flags > 0) {
            sb.append(", flags=" + Message.flagsToString(this.flags));
        }
        if (this.transient_flags > 0) {
            sb.append(", transient_flags=" + Message.transientFlagsToString(this.transient_flags));
        }
        if (this.scope > 0) {
            sb.append(", scope=" + this.scope);
        }
        if (this.exclusion_list != null) {
            sb.append(", exclusion list: " + Arrays.toString(this.exclusion_list));
        }
        return sb.toString();
    }
}

