/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.OneTimeAddressGenerator;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class UPerf
extends ReceiverAdapter {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "uperf";
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile View view;
    protected final List<Address> site_masters = new ArrayList<Address>();
    protected volatile boolean looping = true;
    protected Thread event_loop_thread;
    @Property
    protected boolean sync = true;
    @Property
    protected boolean oob = false;
    @Property
    protected int num_threads = 25;
    @Property
    protected int num_msgs = 20000;
    @Property
    protected int msg_size = 1000;
    @Property
    protected int anycast_count = 2;
    @Property
    protected boolean use_anycast_addrs;
    @Property
    protected boolean msg_bundling = true;
    @Property
    protected double read_percentage = 0.8;
    @Property
    protected boolean get_before_put = false;
    private static final Method[] METHODS = new Method[16];
    private static final short START = 0;
    private static final short GET = 1;
    private static final short PUT = 2;
    private static final short GET_CONFIG = 3;
    private static final short SET = 4;
    private static final short QUIT_ALL = 5;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] BUFFER = new byte[this.msg_size];
    static NumberFormat f;

    public void init(String props, String name, boolean xsite, AddressGenerator generator, int bind_port) throws Throwable {
        this.channel = new JChannel(props);
        if (generator != null) {
            this.channel.addAddressGenerator(generator);
        }
        if (name != null) {
            this.channel.setName(name);
        }
        if (bind_port > 0) {
            TP transport = this.channel.getProtocolStack().getTransport();
            transport.setBindPort(bind_port);
        }
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, this);
        this.disp.setMethodLookup(new MethodLookup(){

            @Override
            public Method findMethod(short id) {
                return METHODS[id];
            }
        });
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        if (xsite) {
            List<String> site_names = UPerf.getSites(this.channel);
            for (String site_name : site_names) {
                try {
                    SiteMaster sm = new SiteMaster(site_name);
                    this.site_masters.add(sm);
                }
                catch (Throwable t) {
                    System.err.println("failed creating site master: " + t);
                }
            }
        }
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        Config config = (Config)this.disp.callRemoteMethod(coord, new MethodCall(3, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config);
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
        Util.close((Closeable)this.channel);
    }

    protected void startEventThread() {
        this.event_loop_thread = new Thread("EventLoop"){

            @Override
            public void run() {
                try {
                    UPerf.this.eventLoop();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    UPerf.this.stop();
                }
            }
        };
        this.event_loop_thread.setDaemon(true);
        this.event_loop_thread.start();
    }

    protected void stopEventThread() {
        Thread tmp = this.event_loop_thread;
        this.looping = false;
        if (tmp != null) {
            tmp.interrupt();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        this.view = new_view;
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
        this.addSiteMastersToMembers();
    }

    protected void addSiteMastersToMembers() {
        if (!this.site_masters.isEmpty()) {
            for (Address sm : this.site_masters) {
                if (this.members.contains(sm)) continue;
                this.members.add(sm);
            }
        }
    }

    public Results startTest() throws Throwable {
        this.BUFFER = new byte[this.msg_size];
        this.addSiteMastersToMembers();
        System.out.println("invoking " + this.num_msgs + " RPCs of " + Util.printBytes(this.BUFFER.length) + ", sync=" + this.sync + ", oob=" + this.oob + ", msg_bundling=" + this.msg_bundling + ", use_anycast_addrs=" + this.use_anycast_addrs);
        int total_gets = 0;
        int total_puts = 0;
        AtomicInteger num_msgs_sent = new AtomicInteger(0);
        Invoker[] invokers = new Invoker[this.num_threads];
        for (int i = 0; i < invokers.length; ++i) {
            invokers[i] = new Invoker(this.members, this.num_msgs, num_msgs_sent);
        }
        long start = System.currentTimeMillis();
        for (Invoker invoker : invokers) {
            invoker.start();
        }
        for (Invoker invoker : invokers) {
            invoker.join();
            total_gets += invoker.numGets();
            total_puts += invoker.numPuts();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println("\ndone (in " + total_time + " ms)");
        return new Results(total_gets, total_puts, total_time);
    }

    public void quitAll() {
        Util.sleepRandom(10L, 10000L);
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventThread();
    }

    public void set(String field_name, Object value) {
        Field field = Util.getField(this.getClass(), field_name);
        if (field == null) {
            System.err.println("Field " + field_name + " not found");
        } else {
            Util.setField(field, this, value);
            System.out.println(field.getName() + "=" + value);
        }
    }

    public byte[] get(long key) {
        return this.BUFFER;
    }

    public void put(long key, byte[] val) {
    }

    public Config getConfig() {
        Config config = new Config();
        for (Field field : Util.getAllDeclaredFields(UPerf.class)) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            config.add(field.getName(), Util.getField(field, this));
        }
        return config;
    }

    protected void applyConfig(Config config) {
        for (Map.Entry<String, Object> entry : config.values.entrySet()) {
            Field field = Util.getField(this.getClass(), entry.getKey());
            Util.setField(field, this, entry.getValue());
        }
    }

    public void eventLoop() throws Throwable {
        this.addSiteMastersToMembers();
        while (this.looping) {
            int c = Util.keyPress("[1] Send msgs [2] Print view\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") " + "[8] Set msg size (" + Util.printBytes(this.msg_size) + ")" + " [9] Set anycast count (" + this.anycast_count + ")" + "\n[o] Toggle OOB (" + this.oob + ") [s] Toggle sync (" + this.sync + ") [r] Set read percentage (" + f.format(this.read_percentage) + ") [g] get_before_put (" + this.get_before_put + ") " + "\n[a] Toggle use_anycast_addrs (" + this.use_anycast_addrs + ") [b] Toggle msg_bundling (" + (this.msg_bundling ? "on" : "off") + ")" + "\n[q] Quit [X] quit all\n");
            switch (c) {
                case -1: {
                    break;
                }
                case 49: {
                    this.startBenchmark();
                    break;
                }
                case 50: {
                    this.printView();
                    break;
                }
                case 54: {
                    this.changeFieldAcrossCluster("num_threads", Util.readIntFromStdin("Number of sender threads: "));
                    break;
                }
                case 55: {
                    this.changeFieldAcrossCluster("num_msgs", Util.readIntFromStdin("Number of RPCs: "));
                    break;
                }
                case 56: {
                    this.changeFieldAcrossCluster("msg_size", Util.readIntFromStdin("Message size: "));
                    break;
                }
                case 57: {
                    int tmp = this.getAnycastCount();
                    if (tmp < 0) break;
                    this.changeFieldAcrossCluster("anycast_count", tmp);
                    break;
                }
                case 97: {
                    this.changeFieldAcrossCluster("use_anycast_addrs", !this.use_anycast_addrs);
                    break;
                }
                case 111: {
                    this.changeFieldAcrossCluster("oob", !this.oob);
                    break;
                }
                case 115: {
                    this.changeFieldAcrossCluster("sync", !this.sync);
                    break;
                }
                case 114: {
                    double percentage = UPerf.getReadPercentage();
                    if (!(percentage >= 0.0)) break;
                    this.changeFieldAcrossCluster("read_percentage", percentage);
                    break;
                }
                case 98: {
                    this.changeFieldAcrossCluster("msg_bundling", !this.msg_bundling);
                    break;
                }
                case 103: {
                    this.changeFieldAcrossCluster("get_before_put", !this.get_before_put);
                    break;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
                case 88: {
                    try {
                        RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).setExclusionList(this.local_addr);
                        options.setFlags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
                        this.disp.callRemoteMethods(null, new MethodCall(5, new Object[0]), options);
                    }
                    catch (Throwable t) {
                        System.err.println("Calling quitAll() failed: " + t);
                    }
                    break;
                }
                case 10: 
                case 13: {
                    break;
                }
            }
        }
    }

    void startBenchmark() {
        RspList responses = null;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
            options.setFlags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
            responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_reqs = 0L;
        long total_time = 0L;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = entry.getKey();
            Rsp rsp = entry.getValue();
            Results result = (Results)rsp.getValue();
            if (result != null) {
                total_reqs += result.num_gets + result.num_puts;
                total_time += result.time;
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.BUFFER.length;
        double ms_per_req = (double)total_time / (double)total_reqs;
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        System.out.println("\n");
        System.out.println(Util.bold("Average of " + f.format(total_reqs_sec) + " requests / sec (" + Util.printBytes(throughput) + " / sec), " + f.format(ms_per_req) + " ms /request (prot=" + prot.getName() + ")"));
        System.out.println("\n\n");
    }

    static double getReadPercentage() throws Exception {
        double tmp = Util.readDoubleFromStdin("Read percentage: ");
        if (tmp < 0.0 || tmp > 1.0) {
            System.err.println("read percentage must be >= 0 or <= 1.0");
            return -1.0;
        }
        return tmp;
    }

    int getAnycastCount() throws Exception {
        View tmp_view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (tmp_view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + tmp_view + ")\n");
            return -1;
        }
        return tmp;
    }

    protected void changeFieldAcrossCluster(String field_name, Object value) throws Exception {
        this.disp.callRemoteMethods(null, new MethodCall(4, field_name, value), RequestOptions.SYNC());
    }

    void printView() {
        System.out.println("\n-- view: " + this.view + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static List<String> getSites(JChannel channel) {
        RELAY2 relay = (RELAY2)channel.getProtocolStack().findProtocol((Class<?>)RELAY2.class);
        return relay != null ? relay.siteNames() : new ArrayList(0);
    }

    private Address getReceiver() {
        try {
            List<Address> mbrs = this.channel.getView().getMembers();
            int index = mbrs.indexOf(this.local_addr);
            int new_index = index + 1 % mbrs.size();
            return mbrs.get(new_index);
        }
        catch (Exception e) {
            System.err.println("UPerf.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        block10: {
            String props = null;
            String name = null;
            boolean xsite = true;
            boolean run_event_loop = true;
            OneTimeAddressGenerator addr_generator = null;
            int port = 0;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                if ("-xsite".equals(args[i])) {
                    xsite = Boolean.valueOf(args[++i]);
                    continue;
                }
                if ("-nohup".equals(args[i])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-uuid".equals(args[i])) {
                    addr_generator = new OneTimeAddressGenerator(Long.valueOf(args[++i]));
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.valueOf(args[++i]);
                    continue;
                }
                UPerf.help();
                return;
            }
            UPerf test = null;
            try {
                test = new UPerf();
                test.init(props, name, xsite, addr_generator, port);
                if (run_event_loop) {
                    test.startEventThread();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block10;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UPerf [-props <props>] [-name name] [-xsite <true | false>] [-nohup] [-uuid <UUID>] [-port <bind port>]");
    }

    static {
        try {
            UPerf.METHODS[0] = UPerf.class.getMethod("startTest", new Class[0]);
            UPerf.METHODS[1] = UPerf.class.getMethod("get", Long.TYPE);
            UPerf.METHODS[2] = UPerf.class.getMethod("put", Long.TYPE, byte[].class);
            UPerf.METHODS[3] = UPerf.class.getMethod("getConfig", new Class[0]);
            UPerf.METHODS[4] = UPerf.class.getMethod("set", String.class, Object.class);
            UPerf.METHODS[5] = UPerf.class.getMethod("quitAll", new Class[0]);
            ClassConfigurator.add((short)11000, Results.class);
            f = NumberFormat.getNumberInstance();
            f.setGroupingUsed(false);
            f.setMinimumFractionDigits(2);
            f.setMaximumFractionDigits(2);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Config
    implements Streamable {
        protected Map<String, Object> values = new HashMap<String, Object>();

        public Config add(String key, Object value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Bits.writeString(entry.getKey(), out);
                Util.objectToStream(entry.getValue(), out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Bits.readString(in);
                Object value = Util.objectFromStream(in);
                if (key == null) continue;
                this.values.put(key, value);
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    public static class Results
    implements Streamable {
        long num_gets = 0L;
        long num_puts = 0L;
        long time = 0L;

        public Results() {
        }

        public Results(int num_gets, int num_puts, long time) {
            this.num_gets = num_gets;
            this.num_puts = num_puts;
            this.time = time;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeLong(this.num_gets);
            out.writeLong(this.num_puts);
            out.writeLong(this.time);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.num_gets = in.readLong();
            this.num_puts = in.readLong();
            this.time = in.readLong();
        }

        public String toString() {
            long total_reqs = this.num_gets + this.num_puts;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.time / 1000.0);
            return f.format(total_reqs_per_sec) + " reqs/sec (" + this.num_gets + " GETs, " + this.num_puts + " PUTs total)";
        }
    }

    private class Invoker
    extends Thread {
        private final List<Address> dests = new ArrayList<Address>();
        private final int num_msgs_to_send;
        private final AtomicInteger num_msgs_sent;
        private int num_gets = 0;
        private int num_puts = 0;
        private final int PRINT;

        public Invoker(Collection<Address> dests, int num_msgs_to_send, AtomicInteger num_msgs_sent) {
            this.num_msgs_sent = num_msgs_sent;
            this.dests.addAll(dests);
            this.num_msgs_to_send = num_msgs_to_send;
            this.PRINT = Math.max(num_msgs_to_send / 10, 10);
            this.setName("Invoker-" + UPerf.this.COUNTER.getAndIncrement());
        }

        public int numGets() {
            return this.num_gets;
        }

        public int numPuts() {
            return this.num_puts;
        }

        @Override
        public void run() {
            long i;
            Object[] put_args = new Object[]{0, UPerf.this.BUFFER};
            Object[] get_args = new Object[]{0};
            MethodCall get_call = new MethodCall(1, get_args);
            MethodCall put_call = new MethodCall(2, put_args);
            RequestOptions get_options = new RequestOptions(ResponseMode.GET_ALL, 40000L, false, null);
            RequestOptions put_options = new RequestOptions(UPerf.this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 40000L, true, null);
            RequestOptions get_before_put_options = new RequestOptions(ResponseMode.GET_FIRST, 40000L, true, null, Message.Flag.DONT_BUNDLE, Message.Flag.OOB);
            if (UPerf.this.oob) {
                get_options.setFlags(Message.Flag.OOB);
                put_options.setFlags(Message.Flag.OOB);
            }
            if (!UPerf.this.msg_bundling) {
                get_options.setFlags(Message.Flag.DONT_BUNDLE);
                put_options.setFlags(Message.Flag.DONT_BUNDLE);
            }
            if (UPerf.this.use_anycast_addrs) {
                put_options.useAnycastAddresses(true);
            }
            while ((i = (long)this.num_msgs_sent.getAndIncrement()) < (long)this.num_msgs_to_send) {
                if (i > 0L && i % (long)this.PRINT == 0L) {
                    System.out.print(".");
                }
                boolean get = Util.tossWeightedCoin(UPerf.this.read_percentage);
                try {
                    if (get) {
                        Address target = this.pickTarget();
                        if (target != null && target.equals(UPerf.this.local_addr)) {
                            UPerf.this.get(1L);
                        } else {
                            get_args[0] = i;
                            UPerf.this.disp.callRemoteMethod(target, get_call, get_options);
                        }
                        ++this.num_gets;
                        continue;
                    }
                    Collection<Address> targets = this.pickAnycastTargets();
                    if (UPerf.this.get_before_put) {
                        get_args[0] = i;
                        UPerf.this.disp.callRemoteMethods(targets, get_call, get_before_put_options);
                        ++this.num_gets;
                    }
                    put_args[0] = i;
                    UPerf.this.disp.callRemoteMethods(targets, put_call, put_options);
                    ++this.num_puts;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickTarget() {
            return Util.pickRandomElement(this.dests);
        }

        private Collection<Address> pickAnycastTargets() {
            ArrayList<Address> anycast_targets = new ArrayList<Address>(UPerf.this.anycast_count);
            int index = this.dests.indexOf(UPerf.this.local_addr);
            for (int i = index + 1; i < index + 1 + UPerf.this.anycast_count; ++i) {
                int new_index = i % this.dests.size();
                Address tmp = this.dests.get(new_index);
                if (anycast_targets.contains(tmp)) continue;
                anycast_targets.add(tmp);
            }
            return anycast_targets;
        }
    }
}

