/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.binding.IdGenerator;
import org.hibernate.metamodel.source.annotations.attribute.AttributeOverride;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.hibernate.metamodel.source.annotations.attribute.SingularAttributeSourceImpl;
import org.hibernate.metamodel.source.binder.IdentifierSource;
import org.hibernate.metamodel.source.binder.SimpleIdentifierSource;
import org.hibernate.metamodel.source.binder.SingularAttributeSource;

public class SimpleIdentifierSourceImpl
implements SimpleIdentifierSource {
    private final BasicAttribute attribute;
    private final Map<String, AttributeOverride> attributeOverrideMap;

    public SimpleIdentifierSourceImpl(BasicAttribute attribute, Map<String, AttributeOverride> attributeOverrideMap) {
        if (!attribute.isId()) {
            throw new AssertionFailure(String.format("A non id attribute was passed to SimpleIdentifierSourceImpl: %s", attribute.toString()));
        }
        this.attribute = attribute;
        this.attributeOverrideMap = attributeOverrideMap;
    }

    @Override
    public IdentifierSource.Nature getNature() {
        return IdentifierSource.Nature.SIMPLE;
    }

    @Override
    public SingularAttributeSource getIdentifierAttributeSource() {
        return new SingularAttributeSourceImpl(this.attribute);
    }

    @Override
    public IdGenerator getIdentifierGeneratorDescriptor() {
        return this.attribute.getIdGenerator();
    }
}

