/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class MessageID
implements Externalizable,
Comparable<MessageID>,
Cloneable,
Streamable {
    private static final long serialVersionUID = 878801547232534461L;
    private Address address = null;
    private long id = -1L;

    public MessageID() {
    }

    public MessageID(Address address, long id) {
        this.address = address;
        this.id = id;
    }

    public MessageID(Address address) {
        this.address = address;
    }

    public void setID(long id) {
        this.id = id;
    }

    @Override
    public int compareTo(MessageID other) {
        if (other == null) {
            return 1;
        }
        if (this.getId() < other.getId()) {
            return -1;
        }
        if (this.getId() > other.getId()) {
            return 1;
        }
        return this.address.compareTo(other.address);
    }

    public MessageID copy() {
        return (MessageID)this.clone();
    }

    public long getId() {
        return this.id;
    }

    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return "MessageID{" + this.address + ":" + this.id + "}";
    }

    public Object clone() {
        return new MessageID(this.address, this.id);
    }

    public boolean equals(Object other) {
        return other instanceof MessageID && this.compareTo((MessageID)other) == 0;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public int serializedSize() {
        return Util.size(this.id) + Util.size(this.address);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Util.writeAddress(this.address, out);
        Util.writeLong(this.id, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.address = Util.readAddress(in);
        this.id = Util.readLong(in);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            this.writeTo(objectOutput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.readFrom(objectInput);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

