/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.ApplicationException;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.deployment.ApplicationExceptionDescriptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public class ApplicationExceptionAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List applicationExceptionAnnotations = compositeIndex.getAnnotations(DotName.createSimple((String)ApplicationException.class.getName()));
        if (applicationExceptionAnnotations == null || applicationExceptionAnnotations.isEmpty()) {
            return;
        }
        ApplicationExceptionDescriptions descriptions = new ApplicationExceptionDescriptions();
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DESCRIPTIONS, (Object)descriptions);
        for (AnnotationInstance annotationInstance : applicationExceptionAnnotations) {
            AnnotationTarget target = annotationInstance.target();
            if (!(target instanceof ClassInfo)) {
                throw EjbMessages.MESSAGES.annotationOnlyAllowedOnClass(ApplicationException.class.getName(), target);
            }
            String exceptionClassName = ((ClassInfo)target).name().toString();
            boolean rollback = false;
            AnnotationValue rollBackAnnValue = annotationInstance.value("rollback");
            if (rollBackAnnValue != null) {
                rollback = rollBackAnnValue.asBoolean();
            }
            boolean inherited = true;
            AnnotationValue inheritedAnnValue = annotationInstance.value("inherited");
            if (inheritedAnnValue != null) {
                inherited = inheritedAnnValue.asBoolean();
            }
            descriptions.addApplicationException(exceptionClassName, rollback, inherited);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

