/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.tx;

import javax.ejb.EJBException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;

public abstract class BMTInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(BMTInterceptor.class);
    private final EJBComponent component;

    public BMTInterceptor(EJBComponent component) {
        this.component = component;
    }

    protected abstract Object handleInvocation(InterceptorContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        TransactionManager tm = this.component.getTransactionManager();
        Transaction oldTx = tm.suspend();
        try {
            Object object = this.handleInvocation(context);
            return object;
        }
        finally {
            if (oldTx != null) {
                tm.resume(oldTx);
            }
        }
    }

    protected Exception handleException(InterceptorContext invocation, Throwable ex) throws Exception {
        ApplicationExceptionDetails ae = this.component.getApplicationException(ex.getClass(), invocation.getMethod());
        if (ae != null) {
            throw (Exception)ex;
        }
        if (ex instanceof EJBException) {
            throw (EJBException)ex;
        }
        if (ex instanceof Exception) {
            throw new EJBException((Exception)ex);
        }
        throw new EJBException((Exception)new RuntimeException(ex));
    }

    public EJBComponent getComponent() {
        return this.component;
    }
}

