/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport;

import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public abstract class AbstractTransport
implements Transport {
    private static final Log log = LogFactory.getLog(AbstractTransport.class);
    private final TransportFactory transportFactory;

    protected AbstractTransport(TransportFactory transportFactory) {
        this.transportFactory = transportFactory;
    }

    @Override
    public byte[] readArray() {
        int responseLength = this.readVInt();
        return this.readByteArray(responseLength);
    }

    @Override
    public String readString() {
        byte[] strContent = this.readArray();
        String readString = new String(strContent, HotRodConstants.HOTROD_STRING_CHARSET);
        if (log.isTraceEnabled()) {
            log.tracef("Read string is: %s", readString);
        }
        return readString;
    }

    @Override
    public long readLong() {
        byte[] longBytes = this.readByteArray(8);
        long result = 0L;
        for (byte longByte : longBytes) {
            result <<= 8;
            result ^= (long)longByte & 0xFFL;
        }
        return result;
    }

    @Override
    public void writeLong(long longValue) {
        byte[] b = new byte[8];
        for (int i = 0; i < 8; ++i) {
            b[7 - i] = (byte)(longValue >>> i * 8);
        }
        this.writeBytes(b);
    }

    @Override
    public int readUnsignedShort() {
        byte[] shortBytes = this.readByteArray(2);
        int result = 0;
        for (byte longByte : shortBytes) {
            result <<= 8;
            result = (int)((long)result ^ (long)longByte & 0xFFL);
        }
        return result;
    }

    @Override
    public int read4ByteInt() {
        byte[] b = this.readByteArray(4);
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    @Override
    public void writeString(String string) {
        if (string != null && !string.isEmpty()) {
            this.writeArray(string.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        } else {
            this.writeVInt(0);
        }
    }

    @Override
    public TransportFactory getTransportFactory() {
        return this.transportFactory;
    }

    @Override
    public void writeArray(byte[] toAppend) {
        this.writeVInt(toAppend.length);
        this.writeBytes(toAppend);
    }

    protected abstract void writeBytes(byte[] var1);
}

