/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509IssuerSerialCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509IssuerSerialCredentialCriteria
implements EvaluableCredentialCriteria {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509IssuerSerialCredentialCriteria.class);
    private X500Principal issuer;
    private BigInteger serialNumber;

    public EvaluableX509IssuerSerialCredentialCriteria(X509IssuerSerialCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criteria instance may not be null");
        }
        this.issuer = criteria.getIssuerName();
        this.serialNumber = criteria.getSerialNumber();
    }

    public EvaluableX509IssuerSerialCredentialCriteria(X500Principal newIssuer, BigInteger newSerialNumber) {
        if (newIssuer == null || newSerialNumber == null) {
            throw new IllegalArgumentException("Issuer and serial number may not be null");
        }
        this.issuer = newIssuer;
        this.serialNumber = newSerialNumber;
    }

    @Override
    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy issuer name and serial number criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, does not satisfy criteria");
            return Boolean.FALSE;
        }
        if (!entityCert.getIssuerX500Principal().equals(this.issuer)) {
            return false;
        }
        Boolean result = entityCert.getSerialNumber().equals(this.serialNumber);
        return result;
    }
}

