/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.GIOP.VersionHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;
import org.slf4j.Logger;

public class IIOPProfile
extends ProfileBase
implements Cloneable {
    private IIOPAddress primaryAddress = null;
    private Logger logger;
    private static final int MINIMUM_OPTIONS = 126;

    public IIOPProfile() {
    }

    public IIOPProfile(byte[] data) {
        this();
        this.initFromProfileData(data);
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey, int minor) {
        this();
        this.version = new Version(1, (byte)minor);
        this.primaryAddress = address;
        this.objectKey = objectKey;
        this.components = new TaggedComponentList();
    }

    public IIOPProfile(IIOPAddress address, byte[] objectKey) {
        this(address, objectKey, 2);
    }

    public IIOPProfile(String corbaloc) {
        this();
        this.version = null;
        this.primaryAddress = null;
        this.objectKey = null;
        this.components = null;
        this.corbalocStr = corbaloc;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = config;
        this.logger = this.configuration.getLogger("jacorb.iiop.profile");
        if (this.primaryAddress != null) {
            this.primaryAddress.configure(config);
        }
        if (this.corbalocStr != null) {
            try {
                this.decode_corbaloc(this.corbalocStr);
            }
            catch (Exception e) {
                this.logger.debug("unable to decode_corbaloc", (Throwable)e);
            }
        }
        this.addAlternateAddresses(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode_corbaloc(String address) {
        String addr = address;
        String host = "127.0.0.1";
        int port = 2809;
        int major = 1;
        int minor = 0;
        String errorstr = "Illegal IIOP protocol format in object address format: " + addr;
        int sep = addr.indexOf(58);
        String protocol_identifier = "";
        if (sep != 0) {
            protocol_identifier = addr.substring(0, sep);
        }
        if (sep + 1 == addr.length()) {
            throw new IllegalArgumentException(errorstr);
        }
        if ((sep = (addr = addr.substring(sep + 1)).indexOf(64)) > -1) {
            String ver_str = addr.substring(0, sep);
            addr = addr.substring(sep + 1);
            sep = ver_str.indexOf(46);
            if (sep != -1) {
                try {
                    major = Integer.parseInt(ver_str.substring(0, sep));
                    minor = Integer.parseInt(ver_str.substring(sep + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.version = new Version((byte)major, (byte)minor);
        int ipv6SeperatorStart = -1;
        int ipv6SeperatorEnd = -1;
        ipv6SeperatorStart = addr.indexOf(91);
        if (ipv6SeperatorStart != -1 && (ipv6SeperatorEnd = addr.indexOf(93)) == -1) {
            throw new IllegalArgumentException(errorstr);
        }
        sep = addr.indexOf(58);
        if (sep != -1) {
            if (ipv6SeperatorStart != -1) {
                host = addr.substring(ipv6SeperatorStart + 1, ipv6SeperatorEnd);
                if (addr.charAt(ipv6SeperatorEnd + 1) != ':') throw new IllegalArgumentException(errorstr);
                port = (short)Integer.parseInt(addr.substring(ipv6SeperatorEnd + 2));
            } else {
                try {
                    port = (short)Integer.parseInt(addr.substring(sep + 1));
                    host = addr.substring(0, sep);
                }
                catch (NumberFormatException ill) {
                    throw new IllegalArgumentException(errorstr);
                }
            }
        }
        this.primaryAddress = new IIOPAddress(host, port);
        try {
            this.primaryAddress.configure(this.configuration);
        }
        catch (ConfigurationException ce) {
            this.logger.warn("ConfigurationException", (Throwable)ce);
        }
        this.decode_extensions(protocol_identifier.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode_extensions(String ident) {
        this.components = new TaggedComponentList();
        if (ident.equals("ssliop")) {
            SSL ssl = new SSL();
            ssl.port = (short)this.primaryAddress.getPort();
            String propname = "jacorb.security.ssl.corbaloc_ssliop.supported_options";
            ssl.target_supports = this.get_ssl_options(propname);
            propname = "jacorb.security.ssl.corbaloc_ssliop.required_options";
            ssl.target_requires = this.get_ssl_options(propname);
            CDROutputStream out = new CDROutputStream();
            try {
                out.beginEncapsulatedArray();
                SSLHelper.write(out, ssl);
                this.components.addComponent(new TaggedComponent(20, out.getBufferCopy()));
            }
            finally {
                out.close();
            }
        }
    }

    private short get_ssl_options(String propname) {
        short value = (short)this.configuration.getAttributeAsInteger(propname, 32);
        return value;
    }

    private void addAlternateAddresses(Configuration config) {
        String value = config.getAttribute("jacorb.iiop.alternate_addresses", null);
        if (value == null) {
            return;
        }
        if (value.trim().equals("auto")) {
            this.addNetworkAddresses();
        } else {
            List<String> addresses = Arrays.asList(value.split(","));
            if (!addresses.isEmpty() && this.components == null) {
                this.components = new TaggedComponentList();
            }
            Iterator<String> i = addresses.iterator();
            while (i.hasNext()) {
                IIOPAddress iaddr = new IIOPAddress();
                String addr = i.next();
                if (!iaddr.fromString(addr)) {
                    this.logger.warn("could not decode " + addr + " from jacorb.iiop.alternate_addresses");
                    continue;
                }
                this.components.addComponent(3, iaddr.toCDR());
            }
        }
    }

    private void addNetworkAddresses() {
        if (this.primaryAddress == null) {
            return;
        }
        if (this.components == null) {
            this.components = new TaggedComponentList();
        }
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                Enumeration<InetAddress> ee = ni.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress addr = ee.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress() || addr.getHostAddress().equals(this.primaryAddress.getIP())) continue;
                    IIOPAddress iaddr = new IIOPAddress();
                    iaddr.fromString(addr.toString().substring(1) + ":" + this.primaryAddress.getPort());
                    this.components.addComponent(3, iaddr.toCDR());
                }
            }
        }
        catch (SocketException ex) {
            this.logger.warn("could not get network interfaces, will not add addresses");
        }
    }

    public void writeAddressProfile(CDROutputStream addressProfileStream) {
        VersionHelper.write(addressProfileStream, this.version);
        this.primaryAddress.write(addressProfileStream);
    }

    public void readAddressProfile(CDRInputStream addressProfileStream) {
        this.version = VersionHelper.read(addressProfileStream);
        this.primaryAddress = IIOPAddress.read(addressProfileStream);
        if (this.configuration != null) {
            try {
                this.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", (Throwable)ce);
            }
        }
    }

    public int hash() {
        return this.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        IIOPProfile result = (IIOPProfile)super.clone();
        result.primaryAddress = new IIOPAddress(this.primaryAddress.getHostname(), this.primaryAddress.getPort());
        if (this.configuration != null) {
            try {
                result.primaryAddress.configure(this.configuration);
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", (Throwable)ce);
            }
        }
        result.version = new Version(this.version.major, this.version.minor);
        if (this.objectKey != null) {
            result.objectKey = new byte[this.objectKey.length];
            System.arraycopy(this.objectKey, 0, result.objectKey, 0, this.objectKey.length);
        }
        if (this.components != null) {
            result.components = (TaggedComponentList)this.components.clone();
        }
        return result;
    }

    public boolean is_match(Profile prof) {
        if (prof == null) {
            return false;
        }
        if (prof instanceof IIOPProfile) {
            IIOPProfile other = (IIOPProfile)prof;
            return this.getSSLPort() == other.getSSLPort() && this.primaryAddress.equals(other.primaryAddress) && ((Object)this.getAlternateAddresses()).equals(other.getAlternateAddresses());
        }
        return false;
    }

    public int tag() {
        return 0;
    }

    public ProtocolAddressBase getAddress() {
        return this.primaryAddress;
    }

    public void patchPrimaryAddress(ProtocolAddressBase replacement) {
        if (replacement instanceof IIOPAddress) {
            this.primaryAddress.replaceFrom((IIOPAddress)replacement);
        }
    }

    public List getAlternateAddresses() {
        return this.components.getComponents(3, IIOPAddress.class);
    }

    public SSL getSSL() {
        return (SSL)this.components.getComponent(20, SSLHelper.class);
    }

    public int getSSLPort() {
        TLS_SEC_TRANS tls = this.getTlsSpecFromCSIComponent();
        if (tls != null && tls.addresses.length > 0) {
            return IIOPProfile.adjustedPortNum(tls.addresses[0].port);
        }
        SSL ssl = this.getSSL();
        if (ssl != null) {
            return IIOPProfile.adjustedPortNum(ssl.port);
        }
        return -1;
    }

    public IIOPProfile to_GIOP_1_0() {
        IIOPProfile result = new IIOPProfile(this.primaryAddress, this.objectKey);
        result.version.minor = 0;
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof Profile && this.is_match((Profile)other);
    }

    public int hashCode() {
        return this.primaryAddress.hashCode();
    }

    public String toString() {
        return this.primaryAddress.toString();
    }

    int getSslPortIfSupported(int client_required, int client_supported) {
        TLS_SEC_TRANS tls = this.getTlsSpecFromCSIComponent();
        SSL ssl = (SSL)this.getComponent(20, SSLHelper.class);
        if (tls != null && this.useSsl(client_supported, client_required, tls.target_supports, tls.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            return IIOPProfile.adjustedPortNum(tls.addresses[0].port);
        }
        if (ssl != null && this.useSsl(client_supported, client_required, ssl.target_supports, ssl.target_requires)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
            return IIOPProfile.adjustedPortNum(ssl.port);
        }
        if ((client_required & 0x7E) != 0) {
            throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
        }
        return -1;
    }

    private static int adjustedPortNum(short port) {
        return port < 0 ? port + 65536 : port;
    }

    private boolean useSsl(int clientSupports, int clientRequires, short targetSupports, short targetRequires) {
        return (targetSupports & 0x7E) != 0 && (clientSupports & 0x7E) != 0 && ((targetRequires & 0x7E) != 0 || (clientRequires & 0x7E) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLS_SEC_TRANS getTlsSpecFromCSIComponent() {
        CompoundSecMechList sas = null;
        try {
            sas = (CompoundSecMechList)this.getComponent(33, CompoundSecMechListHelper.class);
        }
        catch (Exception ex) {
            this.logger.info("Not able to process security mech. component");
        }
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            try {
                byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
                CDRInputStream in = new CDRInputStream(null, tagData);
                try {
                    in.openEncapsulatedArray();
                    tls = TLS_SEC_TRANSHelper.read(in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + e);
            }
        }
        return tls;
    }
}

