/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.deployment.ServletResource;
import org.wildfly.extension.undertow.deployment.VirtualFileResource;

public class ServletResourceManager
implements ResourceManager {
    private final FileResourceManager deploymentResourceManager;
    private final Collection<VirtualFile> overlays;
    private final boolean explodedDeployment;

    public ServletResourceManager(VirtualFile resourcesRoot, Collection<VirtualFile> overlays, boolean explodedDeployment) throws IOException {
        this.explodedDeployment = explodedDeployment;
        this.deploymentResourceManager = new FileResourceManager(resourcesRoot.getPhysicalFile(), 0x100000L);
        this.overlays = overlays;
    }

    public Resource getResource(String path) throws IOException {
        Resource res = this.deploymentResourceManager.getResource(path);
        if (res != null) {
            return new ServletResource(this, res);
        }
        String p = path;
        if (p.startsWith("/")) {
            p = p.substring(1);
        }
        if (this.overlays != null) {
            for (VirtualFile overlay : this.overlays) {
                VirtualFile child = overlay.getChild(p);
                if (!child.exists()) continue;
                return new ServletResource(this, new VirtualFileResource(overlay.getPhysicalFile(), child, path));
            }
        }
        return null;
    }

    public boolean isResourceChangeListenerSupported() {
        return this.explodedDeployment;
    }

    public void registerResourceChangeListener(ResourceChangeListener listener) {
        this.deploymentResourceManager.registerResourceChangeListener(listener);
    }

    public void removeResourceChangeListener(ResourceChangeListener listener) {
        this.deploymentResourceManager.removeResourceChangeListener(listener);
    }

    public void close() throws IOException {
        this.deploymentResourceManager.close();
    }

    public List<Resource> list(String path) {
        try {
            String p;
            ArrayList<Resource> ret = new ArrayList<Resource>();
            Resource res = this.deploymentResourceManager.getResource(path);
            if (res != null) {
                for (Resource child : res.list()) {
                    ret.add(new ServletResource(this, child));
                }
            }
            if ((p = path).startsWith("/")) {
                p = p.substring(1);
            }
            if (this.overlays != null) {
                for (VirtualFile overlay : this.overlays) {
                    VirtualFile child = overlay.getChild(p);
                    if (!child.exists()) continue;
                    VirtualFileResource vfsResource = new VirtualFileResource(overlay.getPhysicalFile(), child, path);
                    for (Resource c : vfsResource.list()) {
                        ret.add(new ServletResource(this, c));
                    }
                }
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

