/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.builtin.BeanMetadataBean;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.literal.InterceptedLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.bean.SerializableForwardingBean;

public class InterceptedBeanMetadataBean
extends BeanMetadataBean {
    public InterceptedBeanMetadataBean(BeanManagerImpl beanManager) {
        this(new StringBeanIdentifier(BeanIdentifiers.forBuiltInBean(beanManager, Bean.class, Intercepted.class.getSimpleName())), beanManager);
    }

    protected InterceptedBeanMetadataBean(BeanIdentifier identifier, BeanManagerImpl beanManager) {
        super(identifier, beanManager);
    }

    @Override
    protected Bean<?> newInstance(InjectionPoint ip, CreationalContext<Bean<?>> ctx) {
        this.checkInjectionPoint(ip);
        WeldCreationalContext<Bean<?>> interceptorContext = this.getParentCreationalContext(ctx);
        WeldCreationalContext<Bean<?>> interceptedBeanContext = this.getParentCreationalContext((CreationalContext<?>)interceptorContext);
        Contextual<Bean<?>> interceptedContextual = interceptedBeanContext.getContextual();
        if (interceptedContextual instanceof Bean) {
            Bean bean = (Bean)interceptedContextual;
            if (bean instanceof Serializable) {
                return bean;
            }
            return SerializableForwardingBean.of(this.getBeanManager().getContextId(), bean);
        }
        throw new IllegalArgumentException("Unable to determine @Intercepted Bean<?> for this interceptor.");
    }

    protected void checkInjectionPoint(InjectionPoint ip) {
        if (!(ip.getBean() instanceof Interceptor)) {
            throw new IllegalArgumentException("@Intercepted Bean<?> can only be injected into an interceptor.");
        }
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.singleton(InterceptedLiteral.INSTANCE);
    }

    @Override
    public String toString() {
        return "Implicit Bean [javax.enterprise.inject.spi.Bean] with qualifiers [@Intercepted]";
    }
}

