/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.host.controller.model.jvm.JvmAttributes;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JvmXml {
    public static void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, Namespace expectedNs, List<ModelNode> updates, Set<String> jvmNames) throws XMLStreamException {
        JvmXml.parseJvm(reader, parentAddress, expectedNs, updates, jvmNames, false);
    }

    public static void parseJvm(XMLExtendedStreamReader reader, ModelNode parentAddress, Namespace expectedNs, List<ModelNode> updates, Set<String> jvmNames, boolean server) throws XMLStreamException {
        ModelNode addOp = Util.createAddOperation();
        String name = null;
        Boolean debugEnabled = null;
        String debugOptions = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (name != null) {
                        throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)attribute.getLocalName());
                    }
                    if (!jvmNames.add(value)) {
                        throw ControllerMessages.MESSAGES.duplicateDeclaration("JVM", value, reader.getLocation());
                    }
                    name = value;
                    continue block20;
                }
                case JAVA_HOME: {
                    JvmAttributes.JAVA_HOME.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block20;
                }
                case TYPE: {
                    try {
                        JvmAttributes.TYPE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                        continue block20;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case DEBUG_ENABLED: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    debugEnabled = Boolean.valueOf(value);
                    JvmAttributes.DEBUG_ENABLED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block20;
                }
                case DEBUG_OPTIONS: {
                    if (!server) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    debugOptions = value;
                    JvmAttributes.DEBUG_OPTIONS.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block20;
                }
                case ENV_CLASSPATH_IGNORED: {
                    JvmAttributes.ENV_CLASSPATH_IGNORED.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        if (debugEnabled != null && debugOptions == null && debugEnabled.booleanValue()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEBUG_OPTIONS));
        }
        ModelNode address = parentAddress.clone();
        address.add("jvm", name);
        addOp.get("address").set(address);
        updates.add(addOp);
        boolean hasJvmOptions = false;
        boolean hasEnvironmentVariables = false;
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case HEAP: {
                    JvmXml.parseHeap(reader, addOp);
                    continue block21;
                }
                case PERMGEN: {
                    JvmXml.parsePermgen(reader, addOp);
                    continue block21;
                }
                case STACK: {
                    JvmXml.parseStack(reader, addOp);
                    continue block21;
                }
                case AGENT_LIB: {
                    JvmXml.parseAgentLib(reader, addOp);
                    continue block21;
                }
                case AGENT_PATH: {
                    JvmXml.parseAgentPath(reader, addOp);
                    continue block21;
                }
                case JAVA_AGENT: {
                    JvmXml.parseJavaagent(reader, addOp);
                    continue block21;
                }
                case ENVIRONMENT_VARIABLES: {
                    if (hasEnvironmentVariables) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseEnvironmentVariables(reader, expectedNs, addOp);
                    hasEnvironmentVariables = true;
                    continue block21;
                }
                case JVM_OPTIONS: {
                    if (hasJvmOptions) {
                        throw ControllerMessages.MESSAGES.alreadyDefined(element.getLocalName(), reader.getLocation());
                    }
                    JvmXml.parseJvmOptions(reader, expectedNs, addOp);
                    hasJvmOptions = true;
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public static ModelNode parseEnvironmentVariables(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode addOp) throws XMLStreamException {
        ModelNode properties = new ModelNode();
        while (reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            if (Element.forName((String)reader.getLocalName()) != Element.VARIABLE) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            String[] array = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName()});
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            properties.add(array[0], ParseUtils.parsePossibleExpression((String)array[1]));
        }
        if (!properties.isDefined()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.OPTION));
        }
        addOp.get("environment-variables").set(properties);
        return properties;
    }

    private static void parseHeap(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    if (!JvmXml.checkParseAndSetParameter(JvmAttributes.HEAP_SIZE, value, addOp, (XMLStreamReader)reader)) continue block4;
                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                }
                case MAX_SIZE: {
                    if (!JvmXml.checkParseAndSetParameter(JvmAttributes.MAX_HEAP_SIZE, value, addOp, (XMLStreamReader)reader)) continue block4;
                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parsePermgen(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    if (!JvmXml.checkParseAndSetParameter(JvmAttributes.PERMGEN_SIZE, value, addOp, (XMLStreamReader)reader)) continue block4;
                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                }
                case MAX_SIZE: {
                    if (!JvmXml.checkParseAndSetParameter(JvmAttributes.MAX_PERMGEN_SIZE, value, addOp, (XMLStreamReader)reader)) continue block4;
                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseStack(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean sizeSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    sizeSet = true;
                    if (!JvmXml.checkParseAndSetParameter(JvmAttributes.STACK_SIZE, value, addOp, (XMLStreamReader)reader)) continue block3;
                    throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!sizeSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SIZE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseAgentLib(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    if (JvmXml.checkParseAndSetParameter(JvmAttributes.AGENT_LIB, value, addOp, (XMLStreamReader)reader)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseAgentPath(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    if (JvmXml.checkParseAndSetParameter(JvmAttributes.AGENT_PATH, value, addOp, (XMLStreamReader)reader)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseJavaagent(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean valueSet = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case VALUE: {
                    if (JvmXml.checkParseAndSetParameter(JvmAttributes.JAVA_AGENT, value, addOp, (XMLStreamReader)reader)) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
                    }
                    valueSet = true;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!valueSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.VALUE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static void parseJvmOptions(XMLExtendedStreamReader reader, Namespace expectedNs, ModelNode addOp) throws XMLStreamException {
        ModelNode options = new ModelNode();
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)expectedNs);
            Element element = Element.forName((String)reader.getLocalName());
            if (element == Element.OPTION) {
                ModelNode option = null;
                int count = reader.getAttributeCount();
                block4: for (int i = 0; i < count; ++i) {
                    String attrValue = reader.getAttributeValue(i);
                    if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case VALUE: {
                            option = ParseUtils.parsePossibleExpression((String)attrValue);
                            continue block4;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (option == null) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                }
                options.add(option);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!options.isDefined()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.OPTION));
        }
        addOp.get("jvm-options").set(options);
    }

    public static void writeJVMElement(XMLExtendedStreamWriter writer, String jvmName, ModelNode jvmElement) throws XMLStreamException {
        writer.writeStartElement(Element.JVM.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), jvmName);
        JvmAttributes.TYPE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        JvmAttributes.JAVA_HOME.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        JvmAttributes.DEBUG_ENABLED.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        JvmAttributes.DEBUG_OPTIONS.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        if (JvmAttributes.DEBUG_OPTIONS.isMarshallable(jvmElement) && !JvmAttributes.DEBUG_ENABLED.isMarshallable(jvmElement)) {
            writer.writeAttribute(Attribute.DEBUG_ENABLED.getLocalName(), "false");
        }
        JvmAttributes.ENV_CLASSPATH_IGNORED.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        if (JvmAttributes.HEAP_SIZE.isMarshallable(jvmElement) || JvmAttributes.MAX_HEAP_SIZE.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.HEAP.getLocalName());
            JvmAttributes.HEAP_SIZE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
            JvmAttributes.MAX_HEAP_SIZE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.PERMGEN_SIZE.isMarshallable(jvmElement) || JvmAttributes.MAX_PERMGEN_SIZE.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.PERMGEN.getLocalName());
            JvmAttributes.PERMGEN_SIZE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
            JvmAttributes.MAX_PERMGEN_SIZE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.STACK_SIZE.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.STACK.getLocalName());
            JvmAttributes.STACK_SIZE.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.AGENT_LIB.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.AGENT_LIB.getLocalName());
            JvmAttributes.AGENT_LIB.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.AGENT_PATH.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.AGENT_PATH.getLocalName());
            JvmAttributes.AGENT_PATH.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.JAVA_AGENT.isMarshallable(jvmElement)) {
            writer.writeEmptyElement(Element.JAVA_AGENT.getLocalName());
            JvmAttributes.JAVA_AGENT.marshallAsAttribute(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.OPTIONS.isMarshallable(jvmElement)) {
            JvmAttributes.OPTIONS.marshallAsElement(jvmElement, (XMLStreamWriter)writer);
        }
        if (JvmAttributes.ENVIRONMENT_VARIABLES.isMarshallable(jvmElement)) {
            JvmAttributes.ENVIRONMENT_VARIABLES.marshallAsElement(jvmElement, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private static boolean checkParseAndSetParameter(SimpleAttributeDefinition ad, String value, ModelNode operation, XMLStreamReader reader) throws XMLStreamException {
        boolean alreadyExisted = operation.hasDefined(ad.getName());
        ad.parseAndSetParameter(value, operation, reader);
        return alreadyExisted;
    }
}

